/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;

public class TextInput<T>
extends AbstractTextComponent<T> {
    private static final int ROW_HEIGHT = 18;
    private static final int MAX_ROWS = 25;
    private int rows = 1;
    private boolean expandable = true;

    public TextInput(String id, IModel<T> model) {
        super(id, model);
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        String cssClasses = tag.getAttribute("class");
        if (cssClasses == null) {
            cssClasses = "";
        }
        if (this.getValue().indexOf(10) != -1 || this.rows > 1) {
            if (this.expandable) {
                cssClasses = cssClasses + " expand";
                tag.put("class", (CharSequence)cssClasses);
                String style = tag.getAttribute("style");
                if (style == null) {
                    style = "";
                }
                if (!(style = style.trim()).endsWith(";")) {
                    style = style + ";";
                }
                tag.put("style", (CharSequence)(style + "min-height:" + this.rows * 18 + "px; max-height:" + 450 + "px;"));
            }
            tag.setName("textarea");
            tag.remove("type");
        } else {
            tag.put("value", (CharSequence)this.getValue());
            if (this.expandable) {
                cssClasses = cssClasses + " expandable";
                tag.put("class", (CharSequence)cssClasses);
            }
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (this.getValue().indexOf(10) != -1 || this.rows > 1) {
            this.replaceComponentTagBody(markupStream, openTag, this.getValue());
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }
}

