/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.BeanPropertyEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PolymorphicPropertyEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.hibernate.validator.constraints.NotEmpty;

public class PropertyEditor
extends Panel {
    private Class<?> beanClass;
    private EditContext.EditableProperty property;

    public PropertyEditor(String id, Class<?> beanClass, EditContext.EditableProperty property) {
        this(id, null, beanClass, property);
    }

    public PropertyEditor(String id, String title, Class<?> beanClass, final EditContext.EditableProperty property) {
        super(id);
        this.property = property;
        Method getter = BeanUtils.getGetter(beanClass, property.getName());
        TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
        if (typeConverter != null) {
            this.add(new Component[]{new Label("title", title)});
            this.get("title").setVisible(title != null);
            this.add(new Component[]{typeConverter.createEditor("editor", beanClass, property)});
        } else {
            this.add(new Component[]{new WebMarkupContainer("title")});
            this.get("title").setVisible(false);
            if (Collection.class.isAssignableFrom(getter.getReturnType())) {
                this.add(new Component[]{new ListPropertyEditor("editor", title, beanClass, property)});
            } else if ((getter.getReturnType().getModifiers() & 0x600) != 0) {
                this.add(new Component[]{new PolymorphicPropertyEditor("editor", title, beanClass, property)});
            } else if (getter.getAnnotation(NotNull.class) != null || getter.getAnnotation(NotEmpty.class) != null) {
                this.add(new Component[]{new BeanEditor("editor", (EditContext)property.getValue())});
            } else {
                this.add(new Component[]{new BeanPropertyEditor("editor", title, beanClass, property)});
            }
        }
        Label errorLabel = new Label("error", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return StringUtils.replace((String)property.getError(), (String)"\n", (String)"<br>");
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(property.getError() != null);
            }
        };
        errorLabel.setEscapeModelStrings(false);
        this.add(new Component[]{errorLabel});
        String description = EditorHelper.getDescription(getter);
        if (description != null) {
            Label label = new Label("description", description){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(this.findParent(ListPropertyEditor.class) == null);
                }
            };
            label.setEscapeModelStrings(false);
            this.add(new Component[]{label});
        } else {
            this.add(new Component[]{new WebMarkupContainer("description").setVisible(false)});
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public EditContext.EditableProperty getProperty() {
        return this.property;
    }

    public String getPropertyPath() {
        final String[] path = new String[]{this.property.getName()};
        this.visitParents(Component.class, (IVisitor)new IVisitor<Component, Component>(){

            public void component(Component component, IVisit<Component> visitor) {
                if (component instanceof PropertyEditor) {
                    path[0] = ((PropertyEditor)((Object)component)).getPropertyPath() + "/" + path[0];
                    visitor.stop();
                } else if (component instanceof ListPropertyEditor.ElementItem) {
                    path[0] = String.valueOf(((ListPropertyEditor.ElementItem)((Object)component)).getIndex()) + ":" + path[0];
                }
            }
        });
        if (!path[0].startsWith("/")) {
            path[0] = "/" + path[0];
        }
        return path[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropertyChanged(final AjaxRequestTarget target) {
        Context.pushComponent((Component)((Object)this));
        try {
            final BeanEditor[] beanEditor = new BeanEditor[]{null};
            this.visitParents(BeanEditor.class, (IVisitor)new IVisitor<Component, Void>(){

                public void component(Component object, IVisit<Void> visit) {
                    beanEditor[0] = (BeanEditor)((Object)object);
                }
            });
            if (beanEditor[0] != null) {
                beanEditor[0].visitChildren(Component.class, (IVisitor)new IVisitor<Component, Void>(){

                    public void component(Component object, IVisit<Void> visit) {
                        if (object != PropertyEditor.this) {
                            if (object instanceof TypeEditor) {
                                TypeEditor typeEditor = (TypeEditor)((Object)object);
                                boolean used = false;
                                for (String each : typeEditor.getUsedPropertyPaths()) {
                                    if (!PropertyEditor.this.getPropertyPath().startsWith(each)) continue;
                                    used = true;
                                    break;
                                }
                                if (used) {
                                    target.add(new Component[]{typeEditor});
                                }
                            }
                        } else {
                            visit.dontGoDeeper();
                        }
                    }
                });
            }
        }
        finally {
            Context.popComponent();
        }
    }
}

