/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class PolymorphicPropertyEditor
extends Panel {
    private static final String INHERIT_FROM_PARENT = "Inherit from parent configuration";
    private Class beanClass;
    private EditContext.EditableProperty property;
    private transient Method getter;

    public PolymorphicPropertyEditor(String id, final String title, final Class beanClass, final EditContext.EditableProperty property) {
        super(id);
        this.beanClass = beanClass;
        this.property = property;
        final WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:8px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(EditorHelper.isPropertyRequired(beanClass, property.getName()));
            }
        }});
        wrapper.add(new Component[]{new Label("title", title){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(title != null);
            }
        }});
        ArrayList implementations = new ArrayList();
        ImplementationProvider implementationProvider = this.getGetter().getReturnType().getAnnotation(ImplementationProvider.class);
        if (implementationProvider != null) {
            Class<?> providerClass = implementationProvider.clazz();
            if (providerClass == Void.class) {
                providerClass = this.getGetter().getReturnType();
            }
            implementations.addAll((Collection)ClassUtils.invokeStaticMethod(providerClass, implementationProvider.method()));
        } else {
            implementations.addAll(ClassUtils.findImplementations(this.getGetter().getReturnType(), this.getGetter().getReturnType()));
        }
        EditorHelper.sortAnnotatedElements(implementations);
        Inheritable inheritable = this.getGetter().getAnnotation(Inheritable.class);
        ArrayList<String> choices = new ArrayList<String>();
        if (inheritable != null && !EditorHelper.isEditingRoot()) {
            choices.add(INHERIT_FROM_PARENT);
        }
        for (Class clazz : implementations) {
            choices.add(clazz.getName());
        }
        DropDownChoice typeSelector = new DropDownChoice("type", new IModel(){

            public Object getObject() {
                if (property.getValue() == null) {
                    if (PolymorphicPropertyEditor.this.getGetter().getAnnotation(Inheritable.class) != null) {
                        return PolymorphicPropertyEditor.INHERIT_FROM_PARENT;
                    }
                    return null;
                }
                return ((EditContext)property.getValue()).getBeanClass().getName();
            }

            public void setObject(Object object) {
                try {
                    if (object != null) {
                        if (object.equals(PolymorphicPropertyEditor.INHERIT_FROM_PARENT)) {
                            property.setValue(null);
                        } else {
                            Class<?> clazz = Class.forName((String)object);
                            Constructor<?> constructor = ClassUtils.getConstructor(clazz, beanClass);
                            Object instance = constructor != null ? constructor.newInstance(new Object[]{null}) : clazz.newInstance();
                            property.setValue(new EditContext(instance));
                        }
                    } else {
                        property.setValue(null);
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }

            public void detach() {
            }
        }, choices, new IChoiceRenderer(){

            public Object getDisplayValue(Object object) {
                if (!object.equals(PolymorphicPropertyEditor.INHERIT_FROM_PARENT)) {
                    try {
                        return EditorHelper.getName(Class.forName((String)object));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return object;
            }

            public String getIdValue(Object object, int index) {
                return String.valueOf(index);
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return false;
            }
        };
        if (!EditorHelper.isPropertyRequired(beanClass, property.getName()) && inheritable == null) {
            typeSelector.setNullValid(true);
        }
        typeSelector.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Component editor = PolymorphicPropertyEditor.this.createEditor();
                wrapper.replace(editor);
                target.add(editor);
                PropertyEditor propertyEditor = (PropertyEditor)((Object)PolymorphicPropertyEditor.this.findParent(PropertyEditor.class));
                if (propertyEditor != null) {
                    propertyEditor.onPropertyChanged(target);
                }
            }
        }});
        wrapper.add(new Component[]{typeSelector});
        wrapper.add(new Component[]{this.createEditor()});
    }

    private Component createEditor() {
        Object editor = this.property.getValue() != null ? new BeanEditor("editor", (EditContext)this.property.getValue()) : new WebMarkupContainer("editor");
        editor.setOutputMarkupId(true);
        return editor;
    }

    private Method getGetter() {
        if (this.getter == null) {
            this.getter = BeanUtils.getGetter(this.beanClass, this.property.getName());
        }
        return this.getter;
    }
}

