/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.util.StringUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;

public class PasswordField
extends AbstractTextComponent {
    private static final char PASSWORD_MASK_CHAR = '\u2605';

    public PasswordField(String id) {
        super(id);
    }

    public PasswordField(String id, final IModel model, final boolean confirmative) {
        super(id, new IModel(){

            public Object getObject() {
                String password = (String)model.getObject();
                if (password == null) {
                    return null;
                }
                String mask = "";
                for (int i = 0; i < 6; ++i) {
                    mask = mask + '\u2605';
                }
                return mask;
            }

            public void setObject(Object object) {
                String password = (String)object;
                if (password == null) {
                    model.setObject(null);
                } else if (password.indexOf(9733) == -1) {
                    if (confirmative) {
                        model.setObject((Object)StringUtils.hash(password));
                    } else {
                        model.setObject((Object)password);
                    }
                }
            }

            public void detach() {
            }
        });
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        tag.put("value", (CharSequence)this.getValue());
        tag.put("onfocus", (CharSequence)"this.value='';");
        super.onComponentTag(tag);
    }
}

