/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class MultiGroupChoiceEditor
extends TypeEditor {
    public MultiGroupChoiceEditor(String id, Class beanClass, EditContext.EditableProperty property) {
        super(id, beanClass, property);
        IChoiceRenderer renderer = new IChoiceRenderer(){

            public Object getDisplayValue(Object object) {
                if (object != null) {
                    return ((Group)object).getName();
                }
                return "[Everyone]";
            }

            public String getIdValue(Object object, int index) {
                if (object != null) {
                    return ((Group)object).getId().toString();
                }
                return "0";
            }
        };
        Palette palette = new Palette("palette", this.getObjectValueModel(), (IModel)new LoadableDetachableModel(){

            protected Object load() {
                List groups = GroupManager.instance.getAll(null);
                if (MultiGroupChoiceEditor.this.getGetter().getAnnotation(Nullable.class) != null) {
                    groups.add(null);
                }
                Collections.sort(groups, new Comparator<Group>(){

                    @Override
                    public int compare(Group group1, Group group2) {
                        if (group1 != null) {
                            if (group2 != null) {
                                return group1.getName().compareTo(group2.getName());
                            }
                            return 1;
                        }
                        if (group2 != null) {
                            return -1;
                        }
                        return 0;
                    }
                });
                return groups;
            }
        }, renderer, 10, false){

            protected Recorder newRecorderComponent() {
                Recorder recorder = super.newRecorderComponent();
                recorder.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(MultiGroupChoiceEditor.this, "onchange")});
                return recorder;
            }
        };
        palette.setOutputMarkupId(true);
        this.add(new Component[]{palette});
    }
}

