/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.configuration.ConfigurationChooser;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.TextInput;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import com.pmease.quickbuild.web.component.help.ScriptIndicator;
import com.pmease.quickbuild.web.component.help.ScriptableIndicator;
import com.pmease.quickbuild.web.component.help.TemplateIndicator;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class MultiConfigurationPathEditor
extends TypeEditor {
    public MultiConfigurationPathEditor(String id, Class beanClass, EditContext.EditableProperty property) {
        super(id, beanClass, property);
        WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:28px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        final TextInput input = new TextInput("input", this.getStringValueModel()){

            @Override
            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"width:100%;");
                }
                super.onComponentTag(tag);
            }
        };
        input.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(this, "onchange")});
        Multiline multiline = this.getGetter().getAnnotation(Multiline.class);
        if (multiline != null) {
            input.setRows(multiline.value());
        } else if (this.getGetter().getAnnotation(Script.class) != null) {
            input.setRows(4);
        } else if (this.getGetter().getAnnotation(Scriptable.class) == null) {
            input.setExpandable(false);
        }
        input.setOutputMarkupId(true);
        wrapper.add(new Component[]{input});
        if (this.getGetter().getAnnotation(Scriptable.class) != null) {
            wrapper.add(new Component[]{new ScriptableIndicator("indicator", beanClass)});
        } else if (this.getGetter().getAnnotation(Script.class) != null) {
            wrapper.add(new Component[]{new ScriptIndicator("indicator", beanClass)});
        } else if (this.getGetter().getAnnotation(Template.class) != null) {
            wrapper.add(new Component[]{new TemplateIndicator("indicator", beanClass)});
        } else {
            wrapper.add(new Component[]{new WebMarkupContainer("indicator")});
        }
        wrapper.add(new Component[]{new InternalImage("trigger", "/images/tree.gif").add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationChooser(componentId, Configuration.ROOT_ID, true, new TreeState(){

                    @Override
                    public boolean isExpanded(Serializable nodeKey) {
                        return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                    }

                    @Override
                    public void setExpanded(Serializable nodeKey, boolean expanded) {
                        WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                    }
                }){

                    @Override
                    protected WebMarkupContainer newSelectLink(String id, Configuration configuration) {
                        final String pathName = configuration.getPathName();
                        return new WebMarkupContainer(id){

                            protected void onComponentTag(ComponentTag tag) {
                                super.onComponentTag(tag);
                                tag.put("onclick", (CharSequence)("this.focus(); var input = document.getElementById('" + input.getMarkupId() + "'); if ($.trim(input.value).length==0) " + "input.value='" + pathName + "'; else input.value+=', " + pathName + "';"));
                                tag.put("style", (CharSequence)"cursor:pointer;");
                            }
                        };
                    }
                };
            }
        }})});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(MultiConfigurationPathEditor.this.isRequired());
            }
        }});
    }
}

