/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.JavascriptText;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyUsageCallback;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class MultiChoiceEditor
extends TypeEditor {
    private Palette palette;

    public MultiChoiceEditor(String id, Class beanClass, final EditContext.EditableProperty property) {
        super(id, beanClass, property);
        IModel valueModel = new IModel(){

            public Object getObject() {
                Collection selected = (Collection)MultiChoiceEditor.this.getTypeConverter().toObject(MultiChoiceEditor.this.getGetter().getReturnType(), (String)MultiChoiceEditor.this.getStringValueModel().getObject());
                Iterator it = selected.iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (MultiChoiceEditor.this.palette.getChoices().contains(item)) continue;
                    it.remove();
                }
                property.setValue(StringUtils.join((Collection)selected, (String)"\n"));
                if (!(selected instanceof List)) {
                    ArrayList list = new ArrayList(selected);
                    Collections.sort(list);
                    return list;
                }
                return selected;
            }

            public void setObject(Object object) {
                MultiChoiceEditor.this.getStringValueModel().setObject((Object)MultiChoiceEditor.this.getTypeConverter().toString(object));
            }

            public void detach() {
            }
        };
        IChoiceRenderer choiceRenderer = new IChoiceRenderer(){

            public Object getDisplayValue(Object object) {
                return object;
            }

            public String getIdValue(Object object, int index) {
                return new String(Hex.encodeHex((byte[])((String)object).getBytes()));
            }
        };
        boolean allowOrder = List.class.isAssignableFrom(this.getGetter().getReturnType());
        this.palette = new Palette("palette", valueModel, (IModel)new LoadableDetachableModel(){

            protected Object load() {
                return MultiChoiceEditor.this.trackPropertyUsage(new PropertyUsageCallback<Object>(){

                    @Override
                    public Object execute() {
                        ArrayList<String> choices = new ArrayList<String>();
                        if (MultiChoiceEditor.this.getGetter().getAnnotation(Choices.class) != null) {
                            choices.addAll(Arrays.asList(MultiChoiceEditor.this.getGetter().getAnnotation(Choices.class).value()));
                        } else {
                            ChoiceProvider choiceProvider = MultiChoiceEditor.this.getGetter().getAnnotation(ChoiceProvider.class);
                            Validate.notNull((Object)choiceProvider);
                            choices.addAll((Collection)ClassUtils.invokeStaticMethod(MultiChoiceEditor.this.getBeanClass(), choiceProvider.value()));
                        }
                        return choices;
                    }
                });
            }
        }, choiceRenderer, 10, allowOrder){

            protected Recorder newRecorderComponent() {
                Recorder recorder = super.newRecorderComponent();
                recorder.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(MultiChoiceEditor.this, "onchange")});
                return recorder;
            }
        };
        this.palette.setOutputMarkupId(true);
        this.add(new Component[]{this.palette});
        this.add(new Component[]{new JavascriptText("shrink", (IModel<String>)new AbstractReadOnlyModel(){

            public Object getObject() {
                return "shrinkColumn(\"" + MultiChoiceEditor.this.palette.getMarkupId() + "\")";
            }
        })});
    }
}

