/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Sortable;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Selectable;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.SortBehavior;
import com.pmease.quickbuild.web.behavior.SortPosition;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.component.help.PropertyHelpPanel;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ListPropertyEditor
extends Panel {
    private Class beanClass;
    private EditContext.EditableProperty property;
    private transient Method getter;
    private transient Class elementClass;
    private transient List<Method> elementEditables;

    public ListPropertyEditor(String id, final String title, final Class beanClass, EditContext.EditableProperty property) {
        super(id);
        this.beanClass = beanClass;
        this.property = property;
        final List editContexts = (List)property.getValue();
        final List selectableEditContexts = Selectable.wrap(editContexts);
        this.add(new Component[]{new Label("title", title){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(title != null);
            }
        }});
        IndicatingAjaxButton addNew = new IndicatingAjaxButton("addNew"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                EditorHelper.updateFormModels(form);
                try {
                    Constructor<?> constructor = ClassUtils.getConstructor(ListPropertyEditor.this.getElementClass(), beanClass);
                    Object instance = constructor != null ? constructor.newInstance(new Object[]{null}) : ListPropertyEditor.this.getElementClass().newInstance();
                    EditContext newEditContext = new EditContext(instance);
                    editContexts.add(newEditContext);
                    selectableEditContexts.add(new Selectable<EditContext>(newEditContext));
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                target.add(new Component[]{ListPropertyEditor.this});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        addNew.setDefaultFormProcessing(false);
        this.add(new Component[]{addNew});
        IndicatingAjaxButton deleteSelected = new IndicatingAjaxButton("deleteSelected"){

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                EditorHelper.updateFormModels(form);
                Iterator it = selectableEditContexts.iterator();
                while (it.hasNext()) {
                    Selectable selectable = (Selectable)it.next();
                    if (!selectable.isSelected()) continue;
                    editContexts.remove(selectable.getBean());
                    it.remove();
                }
                target.add(new Component[]{ListPropertyEditor.this});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        deleteSelected.setDefaultFormProcessing(false);
        this.add(new Component[]{deleteSelected});
        final AjaxCheckBox allSelector = new AjaxCheckBox("allSelector", new IModel(){

            public Object getObject() {
                boolean allSelected = true;
                for (Selectable selectable : selectableEditContexts) {
                    if (selectable.isSelected()) continue;
                    allSelected = false;
                }
                return allSelected;
            }

            public void setObject(Object object) {
                boolean allSelected = (Boolean)object;
                for (Selectable selectable : selectableEditContexts) {
                    selectable.setSelected(allSelected);
                }
            }

            public void detach() {
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onUpdate(AjaxRequestTarget target) {
            }
        };
        allSelector.setOutputMarkupId(true);
        allSelector.add(new Behavior[]{new Behavior(){

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                String existingOnClickScript = tag.getAttribute("onclick");
                tag.put("onclick", (CharSequence)("var checked=this.checked;$(this).closest('table').find('.row-selector').each(function() {this.checked = checked;});" + existingOnClickScript));
            }
        }});
        this.add(new Component[]{allSelector});
        this.add(new Component[]{new ListView("headerColumns", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                return ListPropertyEditor.this.getElementEditables();
            }
        }){

            protected void populateItem(final ListItem item) {
                Method method = (Method)item.getModelObject();
                item.add(new Component[]{new Label("name", EditorHelper.getName(method))});
                WebMarkupContainer helpTrigger = new WebMarkupContainer("helpTrigger");
                item.add(new Component[]{helpTrigger});
                if (EditorHelper.getDescription(method) == null) {
                    helpTrigger.setVisible(false);
                }
                helpTrigger.add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        return new PropertyHelpPanel("helpPanel", (IModel<Method>)new LoadableDetachableModel(){

                            protected Object load() {
                                return item.getModelObject();
                            }
                        }).add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"help")), " ")});
                    }
                }.hoverMode(true)});
            }
        }});
        WebMarkupContainer sortBody = new WebMarkupContainer("sortBody");
        this.add(new Component[]{sortBody});
        sortBody.add(new Component[]{new ListView("rows", selectableEditContexts){

            protected ListItem newItem(int index, IModel itemModel) {
                return new ElementItem(index, itemModel);
            }

            protected void populateItem(final ListItem rowItem) {
                EditContext editContext = (EditContext)((Selectable)rowItem.getModelObject()).getBean();
                rowItem.add(new Component[]{new Label("error", editContext.getError() != null ? editContext.getError() : " "){

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("colspan", ListPropertyEditor.this.getElementEditables().size() + 1);
                    }
                }});
                if (editContext.getError() == null) {
                    rowItem.get("error").setVisible(false);
                }
                rowItem.add(new Component[]{new WebMarkupContainer("dragHandle")});
                rowItem.get("dragHandle").setVisible(ListPropertyEditor.this.getGetter().getAnnotation(Sortable.class) != null);
                rowItem.add(new Component[]{new AjaxCheckBox("rowSelector", new IModel(){

                    public Object getObject() {
                        return ((Selectable)rowItem.getModelObject()).isSelected();
                    }

                    public void setObject(Object object) {
                        ((Selectable)rowItem.getModelObject()).setSelected((Boolean)object);
                    }

                    public void detach() {
                    }
                }){

                    protected boolean wantOnSelectionChangedNotifications() {
                        return true;
                    }

                    protected void onUpdate(AjaxRequestTarget target) {
                        target.add(new Component[]{allSelector});
                    }
                }});
                rowItem.add(new Component[]{new ListView("columns", (IModel)new LoadableDetachableModel(){

                    protected Object load() {
                        return ListPropertyEditor.this.getElementEditables();
                    }
                }){

                    protected void populateItem(ListItem columnItem) {
                        Method getter = (Method)columnItem.getModelObject();
                        EditContext editContext = (EditContext)((Selectable)rowItem.getModelObject()).getBean();
                        EditContext.EditableProperty property = editContext.getProperty(BeanUtils.getPropertyName(getter));
                        PropertyEditor propertyEditor = new PropertyEditor("editor", editContext.getBeanClass(), property);
                        columnItem.add(new Component[]{propertyEditor});
                    }
                }});
            }
        }});
        if (this.getGetter().getAnnotation(Sortable.class) != null) {
            sortBody.add(new Behavior[]{new SortBehavior(){

                @Override
                public void onSort(AjaxRequestTarget target, SortPosition from, SortPosition to) {
                    Object oldEditContext = editContexts.remove(from.getItemIndex());
                    editContexts.add(to.getItemIndex(), oldEditContext);
                    Selectable oldSelectable = (Selectable)selectableEditContexts.remove(from.getItemIndex());
                    selectableEditContexts.add(to.getItemIndex(), oldSelectable);
                }
            }.handle(".ui-draggable").items("tr.sortable")});
        }
        this.setOutputMarkupId(true);
    }

    private Method getGetter() {
        if (this.getter == null) {
            this.getter = BeanUtils.getGetter(this.beanClass, this.property.getName());
        }
        return this.getter;
    }

    private Class getElementClass() {
        if (this.elementClass == null) {
            this.elementClass = ClassUtils.getCollectionElementType(this.getGetter().getGenericReturnType());
            if (this.elementClass == null) {
                throw new QuickbuildException(ExceptionUtils.buildMessage("Element type unknown.", "class", this.beanClass.getName(), "property", this.property.getName()));
            }
            if (ClassUtils.isSystemType(this.elementClass)) {
                throw new QuickbuildException(ExceptionUtils.buildMessage("Not supported element type.", "class", this.beanClass.getName(), "property", this.property.getName()));
            }
        }
        return this.elementClass;
    }

    private List<Method> getElementEditables() {
        if (this.elementEditables == null) {
            this.elementEditables = new ArrayList<Method>();
            List<Method> methods = BeanUtils.getGetters(this.getElementClass());
            for (Method method : methods) {
                if (method.getAnnotation(Editable.class) == null) continue;
                this.elementEditables.add(method);
            }
            EditorHelper.sortAnnotatedElements(this.elementEditables);
        }
        return this.elementEditables;
    }

    public static class ElementItem
    extends ListItem {
        public ElementItem(int index, IModel model) {
            super(index, model);
        }
    }
}

