/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyUsageCallback;
import com.pmease.quickbuild.web.component.editor.TextInput;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import com.pmease.quickbuild.web.component.help.ScriptIndicator;
import com.pmease.quickbuild.web.component.help.ScriptableIndicator;
import com.pmease.quickbuild.web.component.help.TemplateIndicator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

public class ExpressionEditor
extends TypeEditor {
    public ExpressionEditor(String id, Class<?> beanClass, EditContext.EditableProperty property) {
        super(id, beanClass, property);
        WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:28px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        final TextInput<String> input = new TextInput<String>("input", this.getStringValueModel()){

            @Override
            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"width:100%;");
                }
                super.onComponentTag(tag);
            }
        };
        Multiline multiline = this.getGetter().getAnnotation(Multiline.class);
        if (multiline != null) {
            input.setRows(multiline.value());
        } else if (this.getGetter().getAnnotation(Script.class) != null) {
            input.setRows(4);
        } else if (this.getGetter().getAnnotation(Scriptable.class) == null) {
            input.setExpandable(false);
        }
        input.setOutputMarkupId(true);
        wrapper.add(new Component[]{input});
        input.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(this, "onchange")});
        if (this.getGetter().getAnnotation(Scriptable.class) != null) {
            wrapper.add(new Component[]{new ScriptableIndicator("indicator", beanClass)});
        } else if (this.getGetter().getAnnotation(Script.class) != null) {
            wrapper.add(new Component[]{new ScriptIndicator("indicator", beanClass)});
        } else if (this.getGetter().getAnnotation(Template.class) != null) {
            wrapper.add(new Component[]{new TemplateIndicator("indicator", beanClass)});
        } else {
            wrapper.add(new Component[]{new WebMarkupContainer("indicator")});
        }
        InternalImage trigger = new InternalImage("trigger", "/images/choose.png");
        trigger.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                return ExpressionEditor.this.trackPropertyUsage(new PropertyUsageCallback<List<MenuItem>>(){

                    @Override
                    public List<MenuItem> execute() {
                        Map<String, String> expressions = new LinkedHashMap<String, String>();
                        Expressions presetExpressions = ExpressionEditor.this.getGetter().getAnnotation(Expressions.class);
                        if (presetExpressions != null) {
                            for (int i = 0; i < presetExpressions.value().length / 2; ++i) {
                                expressions.put(presetExpressions.value()[2 * i], presetExpressions.value()[2 * i + 1]);
                            }
                        } else {
                            ExpressionProvider expressionProvider = ExpressionEditor.this.getGetter().getAnnotation(ExpressionProvider.class);
                            Validate.notNull((Object)expressionProvider);
                            expressions = (Map)ClassUtils.invokeStaticMethod(ExpressionEditor.this.getBeanClass(), expressionProvider.value());
                        }
                        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                        for (Map.Entry entry : expressions.entrySet()) {
                            final String key = (String)entry.getKey();
                            final String value = (String)entry.getValue();
                            menuItems.add(new MenuItem(){

                                @Override
                                public Component render(String componentId) {
                                    return new Label(componentId, key){

                                        protected void onComponentTag(ComponentTag tag) {
                                            super.onComponentTag(tag);
                                            String template = "var input = $('#%s')[0]; input.value='%s'; closePopup($('#%s').closest('.popup')); input.onchange()";
                                            String script = String.format(template, input.getMarkupId(), value, this.getMarkupId());
                                            tag.put("onclick", (CharSequence)script);
                                        }
                                    }.setOutputMarkupId(true);
                                }
                            });
                        }
                        return menuItems;
                    }
                });
            }
        }});
        wrapper.add(new Component[]{trigger});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ExpressionEditor.this.isRequired());
            }
        }});
    }
}

