/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.web.component.JavascriptText;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class EnumEditor
extends TypeEditor {
    private static final String INHERIT_FROM_PARENT = "Inherit from parent configuration";

    public EnumEditor(String id, Class beanClass, final EditContext.EditableProperty property) {
        super(id, beanClass, property);
        WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:8px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(EnumEditor.this.isRequired());
            }
        }});
        ArrayList<String> choices = new ArrayList<String>();
        Inheritable inheritable = this.getGetter().getAnnotation(Inheritable.class);
        if (inheritable != null && !EditorHelper.isEditingRoot()) {
            choices.add(INHERIT_FROM_PARENT);
        }
        EnumSet<Enum> values = EnumSet.allOf(this.getGetter().getReturnType());
        for (Enum value : values) {
            choices.add(value.toString());
        }
        final DropDownChoice dropDownChoice = new DropDownChoice("select", new IModel(){

            public Object getObject() {
                if (property.getValue() == null) {
                    if (EnumEditor.this.getGetter().getAnnotation(Inheritable.class) != null) {
                        return EnumEditor.INHERIT_FROM_PARENT;
                    }
                    return null;
                }
                return property.getValue();
            }

            public void setObject(Object object) {
                if (EnumEditor.INHERIT_FROM_PARENT.equals(object)) {
                    property.setValue(null);
                } else {
                    property.setValue(object);
                }
            }

            public void detach() {
            }
        }, choices);
        if (!EditorHelper.isPropertyRequired(beanClass, property.getName()) && inheritable == null) {
            dropDownChoice.setNullValid(true);
        }
        dropDownChoice.setOutputMarkupId(true);
        wrapper.add(new Component[]{dropDownChoice});
        dropDownChoice.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(this, "onchange")});
        this.add(new Component[]{new JavascriptText("shrink", (IModel<String>)new AbstractReadOnlyModel(){

            public Object getObject() {
                return "shrinkColumn(\"" + dropDownChoice.getMarkupId() + "\")";
            }
        })});
    }
}

