/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.WordUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.setting.GeneralSettingEdit;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.hibernate.validator.constraints.NotEmpty;

public class EditorHelper {
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private static Method formValidateMethod = ClassUtils.getMethod(Form.class, "validate", new Class[0]);
    private static Method formModelUpdateMethod;

    public static String getName(AnnotatedElement element) {
        Editable editable = element.getAnnotation(Editable.class);
        if (editable != null && editable.name().trim().length() != 0) {
            return editable.name();
        }
        if (element instanceof Class) {
            return WordUtils.uncamel(((Class)element).getSimpleName());
        }
        if (element instanceof Field) {
            return WordUtils.uncamel(WordUtils.capitalize((String)((Field)element).getName()));
        }
        if (element instanceof Method) {
            return StringUtils.substringAfter((String)WordUtils.uncamel(((Method)element).getName()), (String)" ");
        }
        if (element instanceof Package) {
            return ((Package)element).getName();
        }
        throw new QuickbuildException("Invalid element type: " + element.getClass().getName());
    }

    public static String getDescription(AnnotatedElement element) {
        Editable editable = element.getAnnotation(Editable.class);
        String description = editable != null ? (editable.descriptionProvider().trim().length() != 0 ? (String)ClassUtils.invokeStaticMethod(ClassUtils.getDeclaringClass(element), editable.descriptionProvider()) : (editable.description().trim().length() != 0 ? editable.description() : null)) : null;
        return StringUtils.replace(description, (String)"$docroot", (String)Bootstrap.docroot);
    }

    public static Collection instantiateCollection(Method getter) {
        if (List.class.isAssignableFrom(getter.getReturnType())) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(getter.getReturnType())) {
            return new HashSet();
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Do not know how to instantiate collection", "type", getter.getDeclaringClass().getName(), "property", BeanUtils.getPropertyName(getter)));
    }

    public static String[] getCategory(AnnotatedElement element) {
        if (element instanceof Class) {
            Class current = (Class)element;
            while (true) {
                Editable editable;
                if ((editable = current.getAnnotation(Editable.class)) != null && editable.category().length != 0) {
                    return editable.category();
                }
                if (current == Object.class) break;
                current = current.getSuperclass();
            }
            return new String[0];
        }
        Editable editable = element.getAnnotation(Editable.class);
        if (editable != null && editable.category().length != 0) {
            return editable.category();
        }
        return new String[0];
    }

    public static int getOrder(AnnotatedElement element) {
        Editable editable = element.getAnnotation(Editable.class);
        if (editable != null) {
            return editable.order();
        }
        return Integer.MAX_VALUE;
    }

    public static void sortAnnotatedElements(List elements) {
        Collections.sort(elements, new Comparator(){

            public int compare(Object o1, Object o2) {
                AnnotatedElement element1 = (AnnotatedElement)o1;
                AnnotatedElement element2 = (AnnotatedElement)o2;
                Advanced advanced1 = element1.getAnnotation(Advanced.class);
                Advanced advanced2 = element2.getAnnotation(Advanced.class);
                if (advanced1 != null && advanced2 == null) {
                    return 1;
                }
                if (advanced1 == null && advanced2 != null) {
                    return -1;
                }
                return EditorHelper.getOrder(element1) - EditorHelper.getOrder(element2);
            }
        });
    }

    public static boolean isPropertyRequired(Class beanType, String property) {
        Method getter = BeanUtils.getGetter(beanType, property);
        if (getter.getReturnType().isPrimitive() || getter.getAnnotation(NotNull.class) != null || getter.getAnnotation(NotEmpty.class) != null) {
            return true;
        }
        Size size = getter.getAnnotation(Size.class);
        if (size != null && size.min() != 0) {
            return true;
        }
        Inheritable inheritable = getter.getAnnotation(Inheritable.class);
        return inheritable != null && inheritable.required() && EditorHelper.isEditingRoot();
    }

    public static Validator getValidator() {
        return validator;
    }

    public static boolean isEditingRoot() {
        GeneralSettingEdit editor = null;
        if (BasePage.get() != null) {
            editor = (GeneralSettingEdit)((Object)BasePage.get().visitChildren(GeneralSettingEdit.class, (IVisitor)new IVisitor<GeneralSettingEdit, GeneralSettingEdit>(){

                public void component(GeneralSettingEdit object, IVisit<GeneralSettingEdit> visit) {
                    visit.stop((Object)object);
                }
            }));
        }
        if (editor != null) {
            return editor.getConfigurationToEdit().isRoot();
        }
        if (Context.getConfiguration() != null) {
            return Context.getConfiguration().isRoot();
        }
        return false;
    }

    public static void updateFormModels(Form form) {
        if (form.isEnabledInHierarchy() && form.isVisibleInHierarchy()) {
            try {
                formValidateMethod.invoke((Object)form, new Object[0]);
                formModelUpdateMethod.invoke((Object)form, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
    }

    static {
        formValidateMethod.setAccessible(true);
        formModelUpdateMethod = ClassUtils.getMethod(Form.class, "updateFormComponentModels", new Class[0]);
        formModelUpdateMethod.setAccessible(true);
    }
}

