/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.annotation.ReadOnly;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.AccessListener;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.EditErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.validation.ValidationException;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.WordUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class EditContext
implements Serializable {
    private Class beanClass;
    private String error;
    private List<EditableProperty> properties = new ArrayList<EditableProperty>();

    public EditContext(Object bean) {
        this(bean, new String[0], true);
    }

    public EditContext(Object bean, String[] propertyNames) {
        this(bean, propertyNames, false);
    }

    public EditContext(Object bean, String[] propertyNames, boolean exclude) {
        this.beanClass = ClassUtils.unproxy(bean.getClass());
        ArrayList<String> includePropertyNames = new ArrayList();
        if (exclude) {
            List<String> propertyNamesToExclude = Arrays.asList(propertyNames);
            List<Method> getters = BeanUtils.getGetters(this.beanClass);
            EditorHelper.sortAnnotatedElements(getters);
            for (Method getter : getters) {
                if (getter.getAnnotation(Editable.class) == null || propertyNamesToExclude.contains(BeanUtils.getPropertyName(getter)) || !BeanUtils.hasSetter(getter)) continue;
                includePropertyNames.add(BeanUtils.getPropertyName(getter));
            }
        } else {
            includePropertyNames = Arrays.asList(propertyNames);
        }
        this.init(bean, includePropertyNames);
    }

    private void init(Object bean, List<String> propertyNames) {
        TypeConverterRegistry typeConverterRegistry = Quickbuild.getInstance(TypeConverterRegistry.class);
        try {
            for (String propertyName : propertyNames) {
                EditableProperty editableProperty;
                Method getter = BeanUtils.getGetter(this.beanClass, propertyName);
                TypeConverter typeConverter = typeConverterRegistry.getTypeConverter(getter);
                if (typeConverter != null) {
                    editableProperty = new EditableProperty(propertyName);
                    String value = typeConverter.toString(getter.invoke(bean, new Object[0]));
                    if (value != null) {
                        value = value.trim();
                    }
                    editableProperty.setValue(value);
                    if (getter.getAnnotation(ReadOnly.class) != null) {
                        editableProperty.setReadOnly(true);
                    }
                    this.properties.add(editableProperty);
                    continue;
                }
                if (Collection.class.isAssignableFrom(getter.getReturnType())) {
                    ArrayList<EditContext> list = new ArrayList<EditContext>();
                    Collection propertyValue = (Collection)getter.invoke(bean, new Object[0]);
                    if (propertyValue != null) {
                        for (Object element : propertyValue) {
                            list.add(new EditContext(element));
                        }
                    }
                    EditableProperty editableProperty2 = new EditableProperty(propertyName);
                    editableProperty2.setValue(list);
                    this.properties.add(editableProperty2);
                    continue;
                }
                if (ClassUtils.isSystemType(getter.getReturnType())) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Type is not supported.", "class", this.beanClass.getName(), "property", propertyName));
                }
                editableProperty = new EditableProperty(propertyName);
                Object beanPropertyValue = getter.invoke(bean, new Object[0]);
                if (beanPropertyValue != null) {
                    editableProperty.setValue(new EditContext(beanPropertyValue));
                } else {
                    editableProperty.setValue(null);
                }
                this.properties.add(editableProperty);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void validate(boolean throwValidationError) {
        this.validate(null, throwValidationError);
    }

    private boolean interpolative(EditableProperty property) {
        return Quickbuild.getInstance(ScriptEngine.class).interpolative((String)property.getValue());
    }

    private void validate(Object parentBean, boolean throwValidationError) {
        if (this.beanClass == ObjectUtils.Null.class) {
            return;
        }
        try {
            Constructor<?> constructor;
            Object bean = parentBean != null ? ((constructor = ClassUtils.getConstructor(this.beanClass, parentBean.getClass())) != null ? constructor.newInstance(parentBean) : this.beanClass.newInstance()) : this.beanClass.newInstance();
            HashSet<String> propertyNames = new HashSet<String>();
            this.error = null;
            for (EditableProperty property : this.properties) {
                if (property.isReadOnly()) continue;
                property.setError(null);
                Method getter = BeanUtils.getGetter(this.beanClass, property.getName());
                Method setter = BeanUtils.getSetter(getter);
                TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
                if (typeConverter != null) {
                    try {
                        Set violations;
                        setter.invoke(bean, typeConverter.toObject(getter.getReturnType(), (String)property.getValue()));
                        if (this.interpolative(property)) continue;
                        String propertyName = property.getName();
                        if (propertyName.length() >= 2) {
                            if (Character.isUpperCase(propertyName.charAt(0)) && !Character.isUpperCase(propertyName.charAt(1))) {
                                propertyName = WordUtils.uncapitalize((String)propertyName);
                            }
                        } else {
                            propertyName = WordUtils.uncapitalize((String)propertyName);
                        }
                        if (!(violations = EditorHelper.getValidator().validateProperty(bean, propertyName, new Class[0])).isEmpty()) {
                            if (throwValidationError) {
                                ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                                throw new ValidationException(violation.getMessage(), "class", this.beanClass.getName(), "property", property.getName(), "value", violation.getInvalidValue());
                            }
                            property.setError(((ConstraintViolation)violations.iterator().next()).getMessage());
                        } else {
                            Inheritable inheritable = getter.getAnnotation(Inheritable.class);
                            if (inheritable != null && inheritable.required() && EditorHelper.isEditingRoot() && property.getValue() == null) {
                                if (throwValidationError) {
                                    throw new ValidationException("This property is required.", "class", this.beanClass.getName(), "property", property.getName());
                                }
                                property.setError("This property is required.");
                            }
                        }
                        if (property.getError() != null) continue;
                        propertyNames.add(property.getName());
                    }
                    catch (ConversionException e) {
                        if (throwValidationError) {
                            throw new ConversionException(e.getMessage(), "class", this.beanClass.getName(), "property", property.getName());
                        }
                        property.setError(e.getMessage());
                    }
                    continue;
                }
                if (Collection.class.isAssignableFrom(getter.getReturnType())) {
                    Collection beanPropertyValue = (Collection)getter.invoke(bean, new Object[0]);
                    if (beanPropertyValue == null) {
                        beanPropertyValue = EditorHelper.instantiateCollection(getter);
                        setter.invoke(bean, beanPropertyValue);
                    } else {
                        beanPropertyValue.clear();
                    }
                    List editContexts = (List)property.getValue();
                    for (EditContext editContext : editContexts) {
                        editContext.validate(bean, throwValidationError);
                    }
                    Class<?> elementType = ClassUtils.getCollectionElementType(getter.getGenericReturnType());
                    if (elementType == null) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage("Element type unknown.", "class", this.beanClass.getName(), "property", property.getName()));
                    }
                    if (ClassUtils.isSystemType(elementType)) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage("Not supported element type.", "class", this.beanClass.getName(), "property", property.getName()));
                    }
                    Constructor<?> constructor2 = ClassUtils.getConstructor(elementType, bean.getClass());
                    for (EditContext editContext : editContexts) {
                        Object element = constructor2 != null ? constructor2.newInstance(bean) : elementType.newInstance();
                        if (!editContext.hasError()) {
                            editContext.update(element);
                        }
                        beanPropertyValue.add(element);
                    }
                    Set violations = EditorHelper.getValidator().validateProperty(bean, property.getName(), new Class[0]);
                    if (!violations.isEmpty()) {
                        if (throwValidationError) {
                            throw new ValidationException(((ConstraintViolation)violations.iterator().next()).getMessage());
                        }
                        property.setError(((ConstraintViolation)violations.iterator().next()).getMessage());
                    }
                    if (property.getError() != null) continue;
                    propertyNames.add(property.getName());
                    continue;
                }
                if (property.getValue() != null) {
                    EditContext editContext = (EditContext)property.getValue();
                    editContext.validate(bean, throwValidationError);
                    Constructor<?> constructor3 = ClassUtils.getConstructor(editContext.getBeanClass(), bean.getClass());
                    Object beanPropertyValue = constructor3 != null ? constructor3.newInstance(bean) : editContext.getBeanClass().newInstance();
                    if (!editContext.hasError()) {
                        editContext.update(beanPropertyValue);
                    }
                    setter.invoke(bean, beanPropertyValue);
                    if (property.getError() != null) continue;
                    propertyNames.add(property.getName());
                    continue;
                }
                setter.invoke(bean, new Object[]{null});
                Set violations = EditorHelper.getValidator().validateProperty(bean, property.getName(), new Class[0]);
                if (!violations.isEmpty()) {
                    if (throwValidationError) {
                        throw new ValidationException(((ConstraintViolation)violations.iterator().next()).getMessage(), "class", this.beanClass.getName(), "property", property.getName());
                    }
                    property.setError(((ConstraintViolation)violations.iterator().next()).getMessage());
                } else {
                    Inheritable inheritable = getter.getAnnotation(Inheritable.class);
                    if (inheritable != null && inheritable.required() && EditorHelper.isEditingRoot()) {
                        if (throwValidationError) {
                            throw new ValidationException(((ConstraintViolation)violations.iterator().next()).getMessage(), "class", this.beanClass.getName(), "property", property.getName());
                        }
                        property.setError("This property is required.");
                    }
                }
                if (property.getError() != null) continue;
                propertyNames.add(property.getName());
            }
            if (bean instanceof Validatable) {
                ((Validatable)bean).validate(propertyNames, new EditErrorContext(this));
                if (throwValidationError) {
                    for (EditableProperty property : this.properties) {
                        if (property.getError() == null) continue;
                        throw new ValidationException(property.getError(), "class", this.getBeanClass().getName(), "property", property.getName());
                    }
                    if (this.error != null) {
                        throw new ValidationException(this.error, "class", this.getBeanClass().getName());
                    }
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public boolean hasError() {
        if (this.error != null) {
            return true;
        }
        for (EditableProperty property : this.properties) {
            if (property.getError() != null) {
                return true;
            }
            if (property.getValue() instanceof EditContext) {
                if (!((EditContext)property.getValue()).hasError()) continue;
                return true;
            }
            if (!(property.getValue() instanceof List)) continue;
            for (Object editContext : (List)property.getValue()) {
                if (!((EditContext)editContext).hasError()) continue;
                return true;
            }
        }
        return false;
    }

    public void update(Object bean) {
        try {
            if (ClassUtils.unproxy(bean.getClass()) != this.beanClass) {
                throw new QuickbuildException("Expecting instance of '" + this.beanClass + "'.");
            }
            for (EditableProperty property : this.properties) {
                Object beanPropertyValue;
                Method getter = BeanUtils.getGetter(this.beanClass, property.getName());
                Method setter = BeanUtils.getSetter(getter);
                TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
                if (typeConverter != null) {
                    setter.invoke(bean, typeConverter.toObject(getter.getReturnType(), (String)property.getValue()));
                    continue;
                }
                if (Collection.class.isAssignableFrom(getter.getReturnType())) {
                    Collection beanPropertyValue2 = (Collection)getter.invoke(bean, new Object[0]);
                    if (beanPropertyValue2 == null) {
                        beanPropertyValue2 = EditorHelper.instantiateCollection(getter);
                        setter.invoke(bean, beanPropertyValue2);
                    } else {
                        beanPropertyValue2.clear();
                    }
                    List editContexts = (List)property.getValue();
                    Class<?> elementType = ClassUtils.getCollectionElementType(getter.getGenericReturnType());
                    if (elementType == null) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage("Element type unknown.", "class", this.beanClass.getName(), "property", property.getName()));
                    }
                    if (ClassUtils.isSystemType(elementType)) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage("Not supported element type.", "class", this.beanClass.getName(), "property", property.getName()));
                    }
                    Constructor<?> constructor = ClassUtils.getConstructor(elementType, bean.getClass());
                    for (int i = 0; i < editContexts.size(); ++i) {
                        Object element = constructor != null ? constructor.newInstance(bean) : elementType.newInstance();
                        ((EditContext)editContexts.get(i)).update(element);
                        beanPropertyValue2.add(element);
                    }
                    continue;
                }
                EditContext editContext = (EditContext)property.getValue();
                if (editContext != null) {
                    Constructor<?> constructor = ClassUtils.getConstructor(editContext.getBeanClass(), bean.getClass());
                    beanPropertyValue = constructor != null ? constructor.newInstance(bean) : editContext.getBeanClass().newInstance();
                    editContext.update(beanPropertyValue);
                } else {
                    beanPropertyValue = null;
                }
                setter.invoke(bean, beanPropertyValue);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public List<EditableProperty> getProperties() {
        return this.properties;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public EditableProperty getProperty(String name) {
        for (EditableProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Can not find editable property.", "class", this.beanClass.getName(), "property", name));
    }

    public static class EditableProperty
    implements Serializable {
        private static List<AccessListener<String>> accessListeners = new ArrayList<AccessListener<String>>();
        private String name;
        private Object value;
        private String error;
        private boolean readOnly;

        private EditableProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public static String getValueAsString(String propertyPath) {
            EditableProperty property = EditableProperty.get(propertyPath);
            if (property != null) {
                return (String)property.getValue();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EditableProperty get(String propertyPath) {
            Validate.notNull((Object)Context.getComponent());
            final String normalizedPropertyPath = EditableProperty.normalizePropertyPath(propertyPath);
            List<AccessListener<String>> list = accessListeners;
            synchronized (list) {
                for (AccessListener<String> each : accessListeners) {
                    each.onAccess(normalizedPropertyPath);
                }
            }
            final PropertyEditor[] propertyEditor = new PropertyEditor[]{null};
            Context.getComponent().visitParents(PropertyEditor.class, new IVisitor<Component, Void>(){

                public void component(Component object, IVisit<Void> visit) {
                    propertyEditor[0] = (PropertyEditor)((Object)object);
                }
            });
            Validate.notNull((Object)((Object)propertyEditor[0]));
            MarkupContainer parent = (MarkupContainer)propertyEditor[0].findParent(BeanEditor.class);
            if (parent == null) {
                parent = propertyEditor[0].getParent();
            }
            return (EditableProperty)parent.visitChildren(PropertyEditor.class, (IVisitor)new IVisitor<PropertyEditor, EditableProperty>(){

                public void component(PropertyEditor propertyEditor, IVisit<EditableProperty> visit) {
                    if (propertyEditor.getPropertyPath().equals(normalizedPropertyPath)) {
                        visit.stop((Object)propertyEditor.getProperty());
                    }
                }
            });
        }

        private static String normalizePropertyPath(String propertyPath) {
            if (!propertyPath.startsWith("/")) {
                PropertyEditor currentPropertyEditor = Context.getComponent().findParent(PropertyEditor.class);
                Validate.notNull((Object)((Object)currentPropertyEditor));
                final String[] path = new String[]{propertyPath};
                currentPropertyEditor.visitParents(Component.class, (IVisitor)new IVisitor<Component, Component>(){

                    public void component(Component component, IVisit<Component> visitor) {
                        if (component instanceof PropertyEditor) {
                            path[0] = ((PropertyEditor)((Object)component)).getPropertyPath() + "/" + path[0];
                            visitor.stop((Object)component);
                        } else if (component instanceof ListPropertyEditor.ElementItem) {
                            path[0] = String.valueOf(((ListPropertyEditor.ElementItem)((Object)component)).getIndex()) + ":" + path[0];
                        }
                    }
                });
                if (!path[0].startsWith("/")) {
                    path[0] = "/" + path[0];
                }
                propertyPath = path[0];
            }
            try {
                propertyPath = propertyPath.replace(':', '-');
                String normalized = "/" + StringUtils.substringAfter((String)new File(propertyPath).getCanonicalPath().replace(File.separator, "/"), (String)"/");
                return normalized.replace('-', ':');
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void registerAccessListener(AccessListener<String> listener) {
            List<AccessListener<String>> list = accessListeners;
            synchronized (list) {
                accessListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void unregisterAccessListener(AccessListener<String> listener) {
            List<AccessListener<String>> list = accessListeners;
            synchronized (list) {
                accessListeners.remove(listener);
            }
        }
    }
}

