/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PasswordField;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class ConfirmativePasswordEditor
extends TypeEditor {
    public ConfirmativePasswordEditor(String id, Class beanClass, EditContext.EditableProperty property) {
        super(id, beanClass, property);
        PasswordField passwordField = new PasswordField("input", this.getPasswordModel(), true);
        passwordField.setOutputMarkupId(true);
        this.add(new Component[]{passwordField});
        PasswordField passwordConfirmationField = new PasswordField("inputAgain", this.getConfirmedPasswordModel(), true);
        this.add(new Component[]{passwordConfirmationField});
        this.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ConfirmativePasswordEditor.this.isRequired());
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("requiredAgain"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ConfirmativePasswordEditor.this.isRequired());
            }
        }});
    }

    protected IModel getPasswordModel() {
        return new IModel(){

            public Object getObject() {
                String value = (String)ConfirmativePasswordEditor.this.getStringValueModel().getObject();
                if (value == null) {
                    return null;
                }
                if (value.indexOf(10) == -1) {
                    return value;
                }
                return StringUtils.substringBefore((String)value, (String)"\n");
            }

            public void setObject(Object object) {
                String passwordConfirmation;
                String password = (String)object;
                if (password == null) {
                    password = "";
                }
                if ((passwordConfirmation = StringUtils.substringAfter((String)((String)ConfirmativePasswordEditor.this.getStringValueModel().getObject()), (String)"\n")) == null) {
                    passwordConfirmation = "";
                }
                ConfirmativePasswordEditor.this.getStringValueModel().setObject((Object)(password + "\n" + passwordConfirmation));
            }

            public void detach() {
            }
        };
    }

    protected IModel getConfirmedPasswordModel() {
        return new IModel(){

            public Object getObject() {
                String value = (String)ConfirmativePasswordEditor.this.getStringValueModel().getObject();
                if (value == null) {
                    return null;
                }
                if (value.indexOf(10) == -1) {
                    return value;
                }
                return StringUtils.substringAfter((String)value, (String)"\n");
            }

            public void setObject(Object object) {
                String password;
                String passwordConfirmation = (String)object;
                if (passwordConfirmation == null) {
                    passwordConfirmation = "";
                }
                if ((password = StringUtils.substringBefore((String)((String)ConfirmativePasswordEditor.this.getStringValueModel().getObject()), (String)"\n")) == null) {
                    password = "";
                }
                ConfirmativePasswordEditor.this.getStringValueModel().setObject((Object)(password + "\n" + passwordConfirmation));
            }

            public void detach() {
            }
        };
    }
}

