/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.configuration.ConfigurationChooser;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.TextInput;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import com.pmease.quickbuild.web.component.help.ScriptableIndicator;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;

public class ConfigurationPathEditor
extends TypeEditor {
    public ConfigurationPathEditor(String id, Class beanClass, EditContext.EditableProperty property) {
        super(id, beanClass, property);
        WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:28px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ConfigurationPathEditor.this.isRequired());
            }
        }});
        final TextInput<String> input = new TextInput<String>("input", this.getStringValueModel());
        input.setOutputMarkupId(true);
        wrapper.add(new Component[]{input});
        input.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(this, "onchange")});
        Multiline multiline = this.getGetter().getAnnotation(Multiline.class);
        if (multiline != null) {
            input.setRows(multiline.value());
        } else if (this.getGetter().getAnnotation(Scriptable.class) == null) {
            input.setExpandable(false);
        }
        if (this.getGetter().getAnnotation(Scriptable.class) != null) {
            wrapper.add(new Component[]{new ScriptableIndicator("indicator", beanClass)});
        } else {
            wrapper.add(new Component[]{new WebMarkupContainer("indicator")});
        }
        wrapper.add(new Component[]{new WebMarkupContainer("trigger"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("src", (CharSequence)"/images/tree.gif");
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationChooser(componentId, Configuration.ROOT_ID, true, new TreeState(){

                    @Override
                    public boolean isExpanded(Serializable nodeKey) {
                        return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                    }

                    @Override
                    public void setExpanded(Serializable nodeKey, boolean expanded) {
                        WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                    }
                }){

                    @Override
                    protected WebMarkupContainer newSelectLink(String id, Configuration configuration) {
                        final String pathName = configuration.getPathName();
                        return new WebMarkupContainer(id){

                            protected void onComponentTag(ComponentTag tag) {
                                super.onComponentTag(tag);
                                String script = String.format("this.focus(); var input = document.getElementById('%s');closePopup($(this).closest('.popup')); input.value='%s'; input.onchange();", input.getMarkupId(), pathName);
                                tag.put("onclick", (CharSequence)script);
                                tag.put("style", (CharSequence)"cursor:pointer;");
                            }
                        };
                    }
                };
            }
        }})});
    }
}

