/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.web.component.JavascriptText;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyUsageCallback;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ChoiceEditor
extends TypeEditor {
    private static final String INHERIT_FROM_PARENT = "Inherit from Parent Configuration";
    private boolean inheritable;

    public ChoiceEditor(String id, Class beanClass, final EditContext.EditableProperty property) {
        super(id, beanClass, property);
        WebMarkupContainer wrapper = new WebMarkupContainer("wrapper"){

            protected void onComponentTag(ComponentTag tag) {
                if (this.findParent(ListPropertyEditor.class) != null) {
                    tag.put("style", (CharSequence)"margin-right:8px;");
                }
            }
        };
        this.add(new Component[]{wrapper});
        wrapper.add(new Component[]{new WebMarkupContainer("required"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ChoiceEditor.this.isRequired());
            }
        }});
        this.inheritable = this.getGetter().getAnnotation(Inheritable.class) != null;
        LoadableDetachableModel selectionsModel = new LoadableDetachableModel(){

            public Object load() {
                return ChoiceEditor.this.trackPropertyUsage(new PropertyUsageCallback<List<String>>(){

                    @Override
                    public List<String> execute() {
                        ArrayList<String> choices = new ArrayList<String>();
                        if (ChoiceEditor.this.inheritable && !EditorHelper.isEditingRoot()) {
                            choices.add(ChoiceEditor.INHERIT_FROM_PARENT);
                        }
                        if (ChoiceEditor.this.getGetter().getAnnotation(Choices.class) != null) {
                            choices.addAll(Arrays.asList(ChoiceEditor.this.getGetter().getAnnotation(Choices.class).value()));
                        } else {
                            ChoiceProvider choiceProvider = ChoiceEditor.this.getGetter().getAnnotation(ChoiceProvider.class);
                            Validate.notNull((Object)choiceProvider);
                            choices.addAll((Collection)ClassUtils.invokeStaticMethod(ChoiceEditor.this.getBeanClass(), choiceProvider.value()));
                        }
                        return choices;
                    }
                });
            }
        };
        final DropDownChoice dropDownChoice = new DropDownChoice("select", new IModel(){

            public Object getObject() {
                if (ChoiceEditor.this.inheritable && property.getValue() == null) {
                    return ChoiceEditor.INHERIT_FROM_PARENT;
                }
                return property.getValue();
            }

            public void setObject(Object object) {
                if (ChoiceEditor.this.inheritable && ChoiceEditor.INHERIT_FROM_PARENT.equals(object)) {
                    property.setValue(null);
                } else {
                    property.setValue(object);
                }
            }

            public void detach() {
            }
        }, (IModel)selectionsModel){

            protected boolean wantOnSelectionChangedNotifications() {
                return false;
            }

            protected CharSequence getDefaultChoice(String selectedValue) {
                if (this.isNullValid()) {
                    String option = this.getLocalizer().getStringIgnoreSettings(this.getNullValidKey(), (Component)((Object)this), null, null);
                    if (Strings.isEmpty((CharSequence)option)) {
                        option = this.getLocalizer().getString("nullValid", (Component)((Object)this), "");
                    }
                    AppendingStringBuffer buffer = new AppendingStringBuffer(64 + option.length());
                    buffer.append("\n<option");
                    if ("".equals(selectedValue)) {
                        buffer.append(" selected=\"selected\"");
                    }
                    buffer.append(" value=\"\">").append(option).append("</option>");
                    return buffer;
                }
                if ("-1".equals(selectedValue) || "".equals(selectedValue)) {
                    String option = this.getLocalizer().getStringIgnoreSettings(this.getNullKey(), (Component)((Object)this), null, null);
                    if (Strings.isEmpty((CharSequence)option)) {
                        option = this.getLocalizer().getString("null", (Component)((Object)this), "Choose One");
                    }
                    return "\n<option selected=\"selected\" value=\"\">" + option + "</option>";
                }
                return "";
            }
        };
        dropDownChoice.add(new Behavior[]{new TypeEditor.PropertyChangeBehavior(this, "onchange")});
        if (!EditorHelper.isPropertyRequired(beanClass, property.getName()) && !this.inheritable) {
            dropDownChoice.setNullValid(true);
        }
        dropDownChoice.setOutputMarkupId(true);
        wrapper.add(new Component[]{dropDownChoice});
        this.add(new Component[]{new JavascriptText("shrink", (IModel<String>)new AbstractReadOnlyModel(){

            public Object getObject() {
                return "shrinkColumn(\"" + dropDownChoice.getMarkupId() + "\")";
            }
        })});
    }
}

