/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class BeanPropertyEditor
extends Panel {
    private Class beanClass;
    private EditContext.EditableProperty property;
    private transient Method getter;

    public BeanPropertyEditor(String id, final String title, final Class<?> beanClass, final EditContext.EditableProperty property) {
        super(id);
        this.beanClass = beanClass;
        this.property = property;
        this.add(new Component[]{new Label("title", title){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(title != null);
            }
        }});
        this.add(new Component[]{new CheckBox("checkbox", new IModel(){

            public Object getObject() {
                return property.getValue() != null;
            }

            public void setObject(Object object) {
                if (((Boolean)object).booleanValue()) {
                    try {
                        Constructor<?> constructor = ClassUtils.getConstructor(BeanPropertyEditor.this.getGetter().getReturnType(), beanClass);
                        Object instance = constructor != null ? constructor.newInstance(new Object[]{null}) : BeanPropertyEditor.this.getGetter().getReturnType().newInstance();
                        property.setValue(new EditContext(instance));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                } else {
                    property.setValue(null);
                }
            }

            public void detach() {
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return false;
            }
        }});
        this.get("checkbox").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                Component editor = BeanPropertyEditor.this.createEditor();
                BeanPropertyEditor.this.replace(editor);
                target.add(editor);
                PropertyEditor propertyEditor = (PropertyEditor)((Object)BeanPropertyEditor.this.findParent(PropertyEditor.class));
                if (propertyEditor != null) {
                    propertyEditor.onPropertyChanged(target);
                }
            }
        }});
        this.add(new Component[]{this.createEditor()});
    }

    private Component createEditor() {
        EditContext editContext = (EditContext)this.property.getValue();
        Object editor = editContext != null && !editContext.getProperties().isEmpty() ? new BeanEditor("editor", (EditContext)this.property.getValue()) : new WebMarkupContainer("editor");
        editor.setOutputMarkupId(true);
        return editor;
    }

    private Method getGetter() {
        if (this.getter == null) {
            this.getter = BeanUtils.getGetter(this.beanClass, this.property.getName());
        }
        return this.getter;
    }
}

