/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.ListPropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.component.help.PropertyHelpPanel;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class BeanEditor
extends Panel {
    private boolean advanced;
    private EditContext editContext;

    public BeanEditor(String id, final EditContext editContext) {
        super(id);
        this.editContext = editContext;
        this.add(new Component[]{new Label("error", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return editContext.getError();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(editContext.getError() != null);
            }
        }});
        if (!editContext.getProperties().isEmpty()) {
            Fragment content = new Fragment("content", "propertiesFrag", (MarkupContainer)this);
            this.add(new Component[]{content});
            ArrayList<EditContext.EditableProperty> basicProperties = new ArrayList<EditContext.EditableProperty>();
            final ArrayList<EditContext.EditableProperty> advancedProperties = new ArrayList<EditContext.EditableProperty>();
            if (editContext.getBeanClass() == Configuration.class) {
                basicProperties.addAll(editContext.getProperties());
            } else {
                for (EditContext.EditableProperty property : editContext.getProperties()) {
                    Method getter = BeanUtils.getGetter(editContext.getBeanClass(), property.getName());
                    if (getter.getAnnotation(Advanced.class) == null) {
                        basicProperties.add(property);
                        continue;
                    }
                    advancedProperties.add(property);
                }
            }
            content.add(new Component[]{new ListView<EditContext.EditableProperty>("basicProperties", basicProperties){

                protected void populateItem(ListItem<EditContext.EditableProperty> item) {
                    BeanEditor.this.renderProperty((ListItem<EditContext.EditableProperty>)item, editContext.getBeanClass());
                }
            }});
            final WebMarkupContainer advancedContainer = new WebMarkupContainer("advancedContainer"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(BeanEditor.this.advanced);
                }
            };
            advancedContainer.setOutputMarkupId(true);
            advancedContainer.setOutputMarkupPlaceholderTag(true);
            content.add(new Component[]{advancedContainer});
            advancedContainer.add(new Component[]{new ListView<EditContext.EditableProperty>("advancedProperties", advancedProperties){

                protected void populateItem(ListItem<EditContext.EditableProperty> item) {
                    BeanEditor.this.renderProperty((ListItem<EditContext.EditableProperty>)item, editContext.getBeanClass());
                }
            }});
            AjaxLink<Void> toggle = new AjaxLink<Void>("toggle"){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(!advancedProperties.isEmpty());
                }

                public void onClick(AjaxRequestTarget target) {
                    BeanEditor.this.advanced = !BeanEditor.this.advanced;
                    target.add(new Component[]{advancedContainer, this});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (BeanEditor.this.advanced) {
                        tag.put("class", (CharSequence)"toggle advanced");
                    } else {
                        tag.put("class", (CharSequence)"toggle");
                    }
                    super.onComponentTag(tag);
                }
            };
            toggle.setOutputMarkupId(true);
            content.add(new Component[]{toggle});
            Label label = new Label("label", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    if (!BeanEditor.this.advanced) {
                        return "Show Advanced <span style=\"font-size:16px;\">&raquo;</span>";
                    }
                    return "Hide Advanced <span style=\"font-size:16px;\">&laquo;</span>";
                }
            });
            label.setEscapeModelStrings(false);
            toggle.add(new Component[]{label});
        } else {
            this.add(new Component[]{new WebMarkupContainer("content")});
        }
        this.setOutputMarkupId(true);
    }

    private void renderProperty(ListItem<EditContext.EditableProperty> item, final Class<?> beanClass) {
        final EditContext.EditableProperty property = (EditContext.EditableProperty)item.getModelObject();
        Method getter = BeanUtils.getGetter(beanClass, property.getName());
        Fragment fragment = new Fragment("property", "columnsFrag", (MarkupContainer)this);
        item.add(new Component[]{fragment});
        fragment.add(new Component[]{new Label("label", EditorHelper.getName(getter))});
        WebMarkupContainer helpTrigger = new WebMarkupContainer("helpTrigger");
        fragment.add(new Component[]{helpTrigger});
        if (EditorHelper.getDescription(getter) == null || this.findParent(ListPropertyEditor.class) == null) {
            helpTrigger.setVisible(false);
        }
        helpTrigger.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new PropertyHelpPanel("helpPanel", (IModel<Method>)new LoadableDetachableModel<Method>(){

                    protected Method load() {
                        return BeanUtils.getGetter(beanClass, property.getName());
                    }
                }).add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"help")), " ")});
            }
        }.hoverMode(true)});
        if (property.isReadOnly()) {
            ViewContext.ViewableProperty viewProp = new ViewContext.ViewableProperty(property.getName());
            viewProp.setValue(property.getValue());
            fragment.add(new Component[]{new PropertyViewer("editor", beanClass, viewProp)});
        } else {
            fragment.add(new Component[]{new PropertyEditor("editor", beanClass, property)});
        }
    }

    public EditContext getEditContext() {
        return this.editContext;
    }
}

