/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.dialog;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.repeater.RepeatingView;

public abstract class Dialog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Component content;

    public Dialog(String title) {
        this.options.put("modal", true);
        this.options.put("autoOpen", "false");
        this.options.put("title", "'" + title + "'");
        this.options.put("minHeight", 50);
    }

    protected abstract Component render(String var1);

    public void open(AjaxRequestTarget target) {
        String dialogMarkupId = UUID.randomUUID().toString();
        RepeatingView dialogs = BasePage.get().getDialogs();
        String id = dialogs.newChildId();
        this.content = this.render(id);
        this.content.setOutputMarkupId(true);
        this.content.setMarkupId(dialogMarkupId);
        dialogs.add(new Component[]{this.content});
        target.add(this.content);
        this.content.setMetaData(BasePage.TRIGGER, Context.getComponent());
        this.options.put("close", String.format("function(){closeDialog('%s');}", this.content.getPageRelativePath()));
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            if (entry.getKey().equals("options")) {
                buffer.append(entry.getValue() + ",");
                continue;
            }
            buffer.append(entry.getKey() + ":" + entry.getValue() + ",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("}");
        target.prependJavaScript(String.format("createDialog('%s', %s);", dialogMarkupId, buffer.toString()));
        target.appendJavaScript(String.format("openDialog($('#%s').parent());", dialogMarkupId));
    }

    public void close(AjaxRequestTarget target) {
        Dialog.close(target, this.content);
    }

    public static void close(AjaxRequestTarget target, Component content) {
        content.remove();
        target.appendJavaScript(String.format("destroyDialog('%s');", content.getMarkupId()));
    }

    public static void closeTopmost(AjaxRequestTarget target) {
        RepeatingView dialogs = BasePage.get().getDialogs();
        Dialog.close(target, dialogs.get(dialogs.size() - 1));
    }

    public Dialog closeOnEscape(boolean closeOnEscape) {
        this.options.put("closeOnEscape", closeOnEscape);
        return this;
    }

    public Dialog dialogClass(String dialogClass) {
        this.options.put("dialogClass", "'" + dialogClass + "'");
        return this;
    }

    public Dialog draggable(boolean draggable) {
        this.options.put("draggable", draggable);
        return this;
    }

    public Dialog height(int height) {
        this.options.put("height", height);
        return this;
    }

    public Dialog maxHeight(int maxHeight) {
        this.options.put("maxHeight", maxHeight);
        return this;
    }

    public Dialog maxWidth(int maxWidth) {
        this.options.put("maxWidth", maxWidth);
        return this;
    }

    public Dialog minHeight(int minHeight) {
        this.options.put("minHeight", minHeight);
        return this;
    }

    public Dialog minWidth(int minWidth) {
        this.options.put("minWidth", minWidth);
        return this;
    }

    public Dialog resizable(boolean resizable) {
        this.options.put("resizable", resizable);
        return this;
    }

    public Dialog show(String show) {
        this.options.put("show", "'" + show + "'");
        return this;
    }

    public Dialog width(int width) {
        this.options.put("width", width);
        return this;
    }

    public Dialog dragStart(String dragStart) {
        this.options.put("dragStart", dragStart);
        return this;
    }

    public Dialog resizeStop(String resizeStop) {
        this.options.put("resizeStop", resizeStop);
        return this;
    }

    public Dialog resizeStart(String resizeStart) {
        this.options.put("resizeStart", resizeStart);
        return this;
    }

    public Dialog options(String options) {
        if (options != null) {
            this.options.put("options", options);
        }
        return this;
    }
}

