/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport.toolbar;

import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.NavigatorLabel;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class SearchNavToolbar
extends AbstractToolbar
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    private String matchPattern;
    private Integer pageNum = 1;
    private static final List<Integer> ROWS_PER_PAGE = ImmutableList.of((Object)5, (Object)10, (Object)20, (Object)50, (Object)100, (Object)200, (Object)500);

    public SearchNavToolbar(DataTable<?> table) {
        super(table);
    }

    public void onInitialize() {
        super.onInitialize();
        WebMarkupContainer span = new WebMarkupContainer("span");
        span.setOutputMarkupId(true);
        this.add(new Component[]{span});
        span.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(this.getTable().getColumns().size())))});
        span.add(new Component[]{this.createFilterForm("filterForm")});
        span.add(new Component[]{this.createNavigationForm("navigationForm")});
    }

    protected Component createFilterForm(String id) {
        return new FilterForm(id);
    }

    protected Component createNavigationForm(String id) {
        return new NavigationForm(id);
    }

    private void updateParams() {
        this.pageNum = this.getTable().getCurrentPage() + 1;
    }

    protected Component createAdvancedLink(String id) {
        return new WebMarkupContainer(id).setVisibilityAllowed(false);
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof SearchPatternChanged) {
            SearchPatternChanged event = (SearchPatternChanged)sink.getPayload();
            this.matchPattern = event.getPattern();
        }
    }

    protected void onPageChanged(AjaxRequestTarget target, int num) {
        DataTable table = this.getTable();
        table.setCurrentPage(num);
        this.updateParams();
        target.add(new Component[]{table});
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }

    public String getMatchPattern() {
        return this.matchPattern;
    }

    public void setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    private class NavigationForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public NavigationForm(String id) {
            super(id);
            this.add(new Component[]{new TextField("currentPage", (IModel)new PropertyModel((Object)SearchNavToolbar.this, "pageNum"))});
            IndicatingAjaxButton submitButton = new IndicatingAjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int totals = SearchNavToolbar.this.getTable().getPageCount();
                    SearchNavToolbar.this.pageNum = Math.min(SearchNavToolbar.this.pageNum, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.onPageChanged(target, SearchNavToolbar.this.pageNum - 1);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            };
            this.add(new Component[]{submitButton});
            this.setDefaultButton((IFormSubmittingComponent)submitButton);
            DropDownChoice rowsChoice = new DropDownChoice("rowsPerPage", (IModel)new PropertyModel((Object)SearchNavToolbar.this.getTable(), "itemsPerPage"), ROWS_PER_PAGE);
            rowsChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (target != null) {
                        SearchNavToolbar.this.pageNum = 1;
                        SearchNavToolbar.this.onPageChanged(target, SearchNavToolbar.this.pageNum - 1);
                    }
                }
            }});
            this.add(new Component[]{rowsChoice});
            this.add(new Component[]{new AjaxButton("previous", this){
                private static final long serialVersionUID = 1L;

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int currentPage = SearchNavToolbar.this.getTable().getCurrentPage() + 1;
                    if (currentPage == 1) {
                        return;
                    }
                    int totals = SearchNavToolbar.this.getTable().getPageCount();
                    SearchNavToolbar.this.pageNum = Math.min(--currentPage, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.onPageChanged(target, SearchNavToolbar.this.pageNum - 1);
                }
            }});
            this.add(new Component[]{new AjaxButton("next", this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int totals;
                    int currentPage = SearchNavToolbar.this.getTable().getCurrentPage() + 1;
                    if (currentPage == (totals = SearchNavToolbar.this.getTable().getPageCount())) {
                        return;
                    }
                    SearchNavToolbar.this.pageNum = Math.min(++currentPage, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.onPageChanged(target, SearchNavToolbar.this.pageNum - 1);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            }});
            this.add(new Component[]{new NavigatorLabel("pageInfo", SearchNavToolbar.this.getTable())});
        }
    }

    private class FilterForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public FilterForm(String id) {
            super(id);
        }

        public void onInitialize() {
            super.onInitialize();
            IndicatingAjaxButton filterSubmit = new IndicatingAjaxButton("filterSubmit", this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, SearchNavToolbar.this.matchPattern));
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            };
            this.add(new Component[]{filterSubmit});
            this.setDefaultButton((IFormSubmittingComponent)filterSubmit);
            TextField patternField = new TextField("pattern", (IModel)new PropertyModel((Object)SearchNavToolbar.this, "matchPattern"));
            this.add(new Component[]{patternField});
            this.add(new Component[]{SearchNavToolbar.this.createAdvancedLink("advancedLink")});
        }
    }
}

