/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport.hibernate;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.web.component.datatablesupport.hibernate.HibernateDataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class HibernateDataTable<T extends AbstractEntity>
extends DataTable<T> {
    private static final long serialVersionUID = 1L;
    private List<String> filterProperties = Lists.newArrayList();
    private List<Criterion> filterCriterions = Lists.newArrayList();

    public HibernateDataTable(String id, List<IColumn<T>> columns, HibernateDataProvider<T> dataProvider, int rowsPerPage) {
        super(id, columns, dataProvider, rowsPerPage);
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)this, (IModel)Model.of((Serializable)((Object)this.getNoRecordMessage()))));
    }

    protected String getNoRecordMessage() {
        return "No Record Found";
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> rowModel) {
        return new OddEvenItem(id, index, rowModel);
    }

    protected Item<IColumn<T>> newCellItem(String id, int index, IModel<IColumn<T>> model) {
        Item item = super.newCellItem(id, index, model);
        String sortProperty = ((IColumn)this.getColumns().get(index)).getSortProperty();
        SortParam sort = this.getProvider().getSort();
        if (sort != null && Objects.equal((Object)sortProperty, (Object)sort.getProperty())) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"ordered")), " ")});
        }
        if (index == 0) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
        }
        if (index == this.getColumns().size() - 1) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
        }
        return item;
    }

    public void onFilterChanged(AjaxRequestTarget target) {
        this.getProvider().setCriterions(this.getCriterions());
        this.setCurrentPage(0);
        target.add(new Component[]{this});
    }

    public void onSearchPattern(AjaxRequestTarget target, String pattern, MatchType matchType) {
        this.filterCriterions = Lists.newArrayList((Object[])this.getFilterCriterions(pattern, matchType));
        this.onFilterChanged(target);
    }

    protected List<Criterion> getCriterions() {
        return Lists.newArrayList(this.filterCriterions);
    }

    public HibernateDataProvider<T> getProvider() {
        return (HibernateDataProvider)super.getDataProvider();
    }

    public static Criterion match(List<String> propertyNames, String pattern, MatchMode mode) {
        if (propertyNames == null || propertyNames.isEmpty() || Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        Criterion criterion = null;
        for (String each : propertyNames) {
            if (criterion == null) {
                criterion = Restrictions.ilike((String)each, (String)pattern, (MatchMode)mode);
                continue;
            }
            criterion = Restrictions.or((Criterion)criterion, (Criterion)Restrictions.ilike((String)each, (String)pattern, (MatchMode)mode));
        }
        return criterion;
    }

    Criterion[] contains(String pattern) {
        Criterion criterion = HibernateDataTable.match(this.getFilterProperties(), pattern, MatchMode.ANYWHERE);
        if (criterion != null) {
            return new Criterion[]{criterion};
        }
        return new Criterion[0];
    }

    Criterion[] excludes(String pattern) {
        Criterion criterion = HibernateDataTable.match(this.getFilterProperties(), pattern, MatchMode.ANYWHERE);
        if (criterion != null) {
            criterion = Restrictions.not((Criterion)criterion);
            return new Criterion[]{criterion};
        }
        return new Criterion[0];
    }

    public Criterion[] getFilterCriterions(String pattern, MatchType matchType) {
        switch (matchType) {
            case CONTAINING: {
                return this.contains(pattern);
            }
            case EXCLUDING: {
                return this.excludes(pattern);
            }
            case STARTWITH: {
                Criterion criterion = HibernateDataTable.match(this.getFilterProperties(), pattern, MatchMode.START);
                if (criterion == null) {
                    return new Criterion[0];
                }
                return new Criterion[]{criterion};
            }
        }
        return new Criterion[0];
    }

    public List<String> getFilterProperties() {
        return this.filterProperties;
    }

    public void setFilterProperties(List<String> filterProperties) {
        this.filterProperties = filterProperties;
    }

    public List<Criterion> getFilterCriterions() {
        return this.filterCriterions;
    }

    public void setFilterCriterions(List<Criterion> filterCriterions) {
        this.filterCriterions = filterCriterions;
    }
}

