/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport.hibernate;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.model.AbstractEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

public class HibernateDataProvider<T extends AbstractEntity>
extends SortableDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> entityType;
    private final IModel<Integer> countModel;
    private List<Criterion> criterions = Lists.newArrayList();

    public HibernateDataProvider(Class<T> entityType) {
        this(entityType, null, null);
    }

    public HibernateDataProvider(Class<T> entityType, SortParam initSort) {
        this(entityType, null, initSort);
    }

    public HibernateDataProvider(Class<T> entityType, List<Criterion> criterions, SortParam initSort) {
        this.entityType = entityType;
        this.countModel = new AbstractReadOnlyModel<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                SearchCriteria criteria = HibernateDataProvider.this.getSearchCriteria();
                criteria.setOrders(new Order[0]);
                return DataManager.instance.count(HibernateDataProvider.this.getEntityType(), criteria);
            }
        };
        if (criterions != null && !criterions.isEmpty()) {
            this.criterions.addAll(criterions);
        }
        if (initSort != null) {
            this.setSort(initSort);
        }
    }

    public Iterator<T> iterator(int first, int count) {
        SortParam sp = this.getSort();
        SearchCriteria criteria = this.getSearchCriteria();
        if (sp != null) {
            Order order = sp.isAscending() ? Order.asc((String)this.getCurrentSortProperty()) : Order.desc((String)this.getCurrentSortProperty());
            criteria.setOrders(new Order[]{order});
        }
        return DataManager.instance.search(this.getEntityType(), criteria, first, count).iterator();
    }

    public int size() {
        return (Integer)this.countModel.getObject();
    }

    public String getCurrentSortProperty() {
        SortParam sp = this.getSort();
        if (sp != null) {
            return sp.getProperty();
        }
        return "id";
    }

    public IModel<T> model(T object) {
        return Model.of(object);
    }

    public SearchCriteria getSearchCriteria() {
        SortParam sp;
        SearchCriteria criteria = new SearchCriteria();
        List<Criterion> crits = this.getCriterions();
        if (!this.getCriterions().isEmpty()) {
            criteria.setCriterions((Criterion[])Iterables.toArray(crits, Criterion.class));
        }
        if ((sp = this.getSort()) != null) {
            String props = sp.getProperty();
            boolean asc = sp.isAscending();
            String[] array = (String[])Iterables.toArray((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)props), String.class);
            ArrayList orders = Lists.newArrayList();
            for (String each : array) {
                orders.add(asc ? Order.asc((String)each) : Order.desc((String)each));
            }
            criteria.setOrders((Order[])Iterables.toArray((Iterable)orders, Order.class));
        }
        return criteria;
    }

    public List<Criterion> getCriterions() {
        return this.criterions;
    }

    public void setCriterions(List<Criterion> criterions) {
        this.criterions = criterions;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public void detach() {
        if (this.countModel != null) {
            this.countModel.detach();
        }
        super.detach();
    }
}

