/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.pmease.quickbuild.web.component.datatablesupport.SelectionChanged;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class SelectionColumn<T extends Serializable>
implements IStyledColumn<T> {
    private Set<T> selections = new HashSet<T>();

    public Component getHeader(String componentId) {
        return new AllSelector(componentId);
    }

    public String getSortProperty() {
        return null;
    }

    public boolean isSortable() {
        return false;
    }

    public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
        cellItem.add(new Component[]{new RowSelector(componentId, rowModel)});
    }

    public void detach() {
    }

    public String getCssClass() {
        return "row-selector";
    }

    public Set<T> getSelections() {
        return this.selections;
    }

    private class RowSelector
    extends Panel
    implements IMarkupResourceStreamProvider {
        private String checkboxMarkupId;

        public RowSelector(String id, IModel<T> keyModel) {
            super(id, keyModel);
            this.checkboxMarkupId = UUID.randomUUID().toString();
            this.setOutputMarkupId(true);
            this.add(new Component[]{new WebMarkupContainer("checkbox"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (SelectionColumn.this.selections.contains(RowSelector.this.getKey())) {
                        tag.put("checked", (CharSequence)"true");
                    }
                }
            }.setMarkupId(this.checkboxMarkupId)});
            this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){

                protected CharSequence getCallbackScript() {
                    String script = "wicketAjaxGet('" + this.getCallbackUrl() + "&checked=' + $('#" + RowSelector.this.checkboxMarkupId + "').attr('checked')";
                    return this.generateCallbackScript(script);
                }

                protected void respond(final AjaxRequestTarget target) {
                    boolean checked = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("checked").toBoolean();
                    if (checked) {
                        SelectionColumn.this.selections.add(RowSelector.this.getKey());
                    } else {
                        SelectionColumn.this.selections.remove(RowSelector.this.getKey());
                    }
                    ((DataTable)RowSelector.this.findParent(DataTable.class)).visitChildren(AllSelector.class, (IVisitor)new IVisitor<AllSelector, Void>(){

                        public void component(AllSelector object, IVisit<Void> visit) {
                            target.add(new Component[]{object});
                            visit.stop();
                        }
                    });
                    target.add(new Component[]{RowSelector.this});
                    RowSelector.this.send((IEventSink)RowSelector.this.getPage(), Broadcast.DEPTH, new SelectionChanged(target));
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    String template = "$('#%s').change(function(){%s})";
                    response.renderOnLoadJavaScript(String.format(template, RowSelector.this.checkboxMarkupId, this.getCallbackScript()));
                }
            }});
        }

        public T getKey() {
            return (Serializable)this.getDefaultModelObject();
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            String script = "<wicket:panel><input type='checkbox' wicket:id='checkbox' class='row-selector'></input></wicket:panel>";
            return new StringResourceStream((CharSequence)script);
        }
    }

    private class AllSelector
    extends Panel
    implements IMarkupResourceStreamProvider {
        private String checkboxMarkupId;

        public AllSelector(String id) {
            super(id);
            this.checkboxMarkupId = UUID.randomUUID().toString();
            this.setOutputMarkupId(true);
            this.add(new Component[]{new WebMarkupContainer("checkbox"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    final boolean[] allChecked = new boolean[]{true};
                    final boolean[] empty = new boolean[]{true};
                    ((DataTable)this.findParent(DataTable.class)).visitChildren(RowSelector.class, (IVisitor)new IVisitor<RowSelector, Void>(){

                        public void component(RowSelector component, IVisit<Void> visit) {
                            empty[0] = false;
                            if (!SelectionColumn.this.selections.contains(component.getKey())) {
                                allChecked[0] = false;
                                visit.stop();
                            }
                        }
                    });
                    if (allChecked[0] && !empty[0]) {
                        tag.put("checked", (CharSequence)"true");
                    }
                }
            }.setMarkupId(this.checkboxMarkupId)});
            this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){

                protected CharSequence getCallbackScript() {
                    String script = "wicketAjaxGet('" + this.getCallbackUrl() + "&checked=' + $('#" + AllSelector.this.checkboxMarkupId + "').attr('checked')";
                    return this.generateCallbackScript(script);
                }

                protected void respond(AjaxRequestTarget target) {
                    final boolean checked = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("checked").toBoolean();
                    ((DataTable)AllSelector.this.findParent(DataTable.class)).visitChildren(RowSelector.class, (IVisitor)new IVisitor<RowSelector, Void>(){

                        public void component(RowSelector component, IVisit<Void> visit) {
                            if (checked) {
                                SelectionColumn.this.selections.add(component.getKey());
                            } else {
                                SelectionColumn.this.selections.remove(component.getKey());
                            }
                        }
                    });
                    AllSelector.this.send((IEventSink)AllSelector.this.getPage(), Broadcast.DEPTH, new SelectionChanged(target));
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    String template = "$('#%s').change(function(){\n\tvar checked = this.checked;\n\t$(this).closest('table').find('input.row-selector').each(function(){\n\t\t\tthis.checked = checked;\n\t});\n\t%s})";
                    response.renderOnLoadJavaScript(String.format(template, AllSelector.this.checkboxMarkupId, this.getCallbackScript()));
                }
            }});
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            String script = "<wicket:panel><input type='checkbox' wicket:id='checkbox' class='row-selector'></input></wicket:panel>";
            return new StringResourceStream((CharSequence)script);
        }
    }
}

