/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.google.common.base.Strings;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.web.component.datatablesupport.EntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class FilterableEntityProvider
extends EntityProvider {
    private static final long serialVersionUID = 1L;
    private Criterion[] criterions = new Criterion[0];
    private final String[] filterProperties;

    public FilterableEntityProvider(Class<? extends AbstractEntity> entityType, SortParam initialSort, String[] filterProperties) {
        super(entityType, initialSort);
        this.filterProperties = filterProperties;
    }

    @Override
    public Criterion[] getCriterions() {
        if (this.criterions == null) {
            this.criterions = new Criterion[0];
        }
        return this.criterions;
    }

    public void setCriterions(Criterion[] criterions) {
        this.criterions = criterions;
    }

    public static Criterion match(String[] propertyNames, String pattern, MatchMode mode) {
        if (propertyNames == null || propertyNames.length == 0 || Strings.isNullOrEmpty((String)pattern)) {
            return null;
        }
        Object criterion = null;
        for (String each : propertyNames) {
            criterion = criterion == null ? Restrictions.ilike((String)each, (String)pattern, (MatchMode)mode) : Restrictions.or((Criterion)criterion, (Criterion)Restrictions.ilike((String)each, (String)pattern, (MatchMode)mode));
        }
        return criterion;
    }

    Criterion[] contains(String pattern) {
        Criterion criterion = FilterableEntityProvider.match(this.getFilterProperties(), pattern, MatchMode.ANYWHERE);
        if (criterion != null) {
            return new Criterion[]{criterion};
        }
        return new Criterion[0];
    }

    Criterion[] excludes(String pattern) {
        Criterion criterion = FilterableEntityProvider.match(this.getFilterProperties(), pattern, MatchMode.ANYWHERE);
        if (criterion != null) {
            criterion = Restrictions.not((Criterion)criterion);
            return new Criterion[]{criterion};
        }
        return new Criterion[0];
    }

    public void filter(String pattern, MatchType matchType) {
        switch (matchType) {
            case CONTAINING: {
                this.setCriterions(this.contains(pattern));
                break;
            }
            case EXCLUDING: {
                this.setCriterions(this.excludes(pattern));
                break;
            }
            case STARTWITH: {
                Criterion criterion = FilterableEntityProvider.match(this.getFilterProperties(), pattern, MatchMode.START);
                if (criterion == null) {
                    this.setCriterions(new Criterion[0]);
                    break;
                }
                this.setCriterions(new Criterion[]{criterion});
            }
        }
    }

    public String[] getFilterProperties() {
        return this.filterProperties;
    }
}

