/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

public abstract class EntityProvider
extends DataProvider<Long> {
    private Class<? extends AbstractEntity> entityType;
    private SortParam initialSort;

    public EntityProvider(Class<? extends AbstractEntity> entityType, SortParam initialSort) {
        this.entityType = entityType;
        this.initialSort = initialSort;
    }

    public SortParam getSort() {
        if (super.getSort() != null) {
            return super.getSort();
        }
        return this.initialSort;
    }

    public Iterator<Long> iterator(int first, int count) {
        Order[] orders = this.getSort() != null && this.getSort().getProperty() != null ? (this.getSort().isAscending() ? new Order[]{Order.asc((String)this.getSort().getProperty())} : new Order[]{Order.desc((String)this.getSort().getProperty())}) : new Order[]{};
        List<? extends AbstractEntity> result = DataManager.instance.search(this.entityType, new SearchCriteria(this.getCriterions(), orders), first, count);
        ArrayList<Long> entityIds = new ArrayList<Long>();
        for (AbstractEntity abstractEntity : result) {
            entityIds.add(abstractEntity.getId());
        }
        return entityIds.iterator();
    }

    public int size() {
        return DataManager.instance.count(this.entityType, new SearchCriteria(this.getCriterions(), new Order[0]));
    }

    protected abstract Criterion[] getCriterions();
}

