/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.google.common.base.Objects;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EntityDataTable
extends DataTable<Long> {
    private static final long serialVersionUID = 1L;
    private final FilterableEntityProvider dataProvider;

    public EntityDataTable(String id, List<IColumn<Long>> columns, FilterableEntityProvider dataProvider) {
        this(id, columns, dataProvider, 25);
    }

    public EntityDataTable(String id, List<IColumn<Long>> columns, FilterableEntityProvider dataProvider, int pageSize) {
        super(id, columns, (IDataProvider)dataProvider, pageSize);
        this.dataProvider = dataProvider;
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)this, (IModel)Model.of((Serializable)((Object)this.getNoRecordMessage()))));
    }

    protected String getNoRecordMessage() {
        return "No Record Found";
    }

    protected Item<Long> newRowItem(String id, int index, IModel<Long> rowModel) {
        return new OddEvenItem(id, index, rowModel);
    }

    protected Item<IColumn<Long>> newCellItem(String id, int index, IModel<IColumn<Long>> model) {
        Item item = super.newCellItem(id, index, model);
        String sortProperty = ((IColumn)this.getColumns().get(index)).getSortProperty();
        SortParam sort = this.dataProvider.getSort();
        if (sort != null && Objects.equal((Object)sortProperty, (Object)sort.getProperty())) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"ordered")), " ")});
        }
        if (index == 0) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
        }
        if (index == this.getColumns().size() - 1) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
        }
        return item;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof SearchPatternChanged) {
            SearchPatternChanged e = (SearchPatternChanged)sink.getPayload();
            this.onFilterChanged(e.getTarget(), e.getPattern(), e.getMatchType());
        }
    }

    private void onFilterChanged(AjaxRequestTarget target, String pattern, MatchType matchType) {
        this.dataProvider.filter(pattern, matchType);
        this.setCurrentPage(0);
        target.add(new Component[]{this});
    }
}

