/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import java.lang.reflect.Method;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class EntityColumn
implements IStyledColumn<Long> {
    private static final long serialVersionUID = 1L;
    private Class<? extends AbstractEntity> entityType;
    private String propertyName;
    private boolean sortable;
    private String cssClass;
    private transient Method getter;

    public EntityColumn(Class<? extends AbstractEntity> entityType, String propertyName, boolean sortable) {
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.sortable = sortable;
    }

    protected Method getGetter(Class<? extends AbstractEntity> entityType) {
        if (this.getter == null) {
            this.getter = BeanUtils.getGetter(entityType, this.propertyName);
        }
        return this.getter;
    }

    public Component getHeader(String componentId) {
        String headerLabel = EditorHelper.getName(this.getGetter(this.entityType));
        return new Label(componentId, headerLabel);
    }

    public String getSortProperty() {
        return this.propertyName;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void detach() {
    }

    public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
        cellItem.add(new Component[]{this.createItemComponent(componentId, rowModel)});
    }

    protected Component createItemComponent(String componentId, IModel<Long> rowModel) {
        Object fieldValue;
        AbstractEntity entity = DataManager.instance.load(this.entityType, (Long)rowModel.getObject());
        Method getter = this.getGetter(this.entityType);
        try {
            fieldValue = getter.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        if (fieldValue == null) {
            return new Label(componentId);
        }
        TypeConverter typeConverter = TypeConverterRegistry.instance.getTypeConverter(getter);
        if (typeConverter != null) {
            return new MultilineText(componentId, typeConverter.toString(fieldValue));
        }
        return new BeanViewer(componentId, new ViewContext(fieldValue));
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public EntityColumn setCssClass(String cssClass) {
        this.cssClass = cssClass;
        return this;
    }

    public Class<? extends AbstractEntity> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<? extends AbstractEntity> entityType) {
        this.entityType = entityType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }
}

