/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.datatablesupport;

import com.google.common.base.Strings;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanColumn
extends EntityColumn {
    private static final long serialVersionUID = 1L;
    private final IModel<String> displayModel;

    public BooleanColumn(Class<? extends AbstractEntity> entityType, String propertyName, boolean sortable) {
        this(entityType, propertyName, sortable, null);
    }

    public BooleanColumn(Class<? extends AbstractEntity> entityType, String propertyName, boolean sortable, String title) {
        super(entityType, propertyName, sortable);
        this.displayModel = !Strings.isNullOrEmpty((String)title) ? Model.of((Serializable)((Object)title)) : null;
    }

    @Override
    public Component getHeader(String componentId) {
        return new Label(componentId, this.displayModel);
    }

    @Override
    public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
        Object fieldValue;
        AbstractEntity entity = DataManager.instance.load(this.getEntityType(), (Long)rowModel.getObject());
        Method getter = this.getGetter(this.getEntityType());
        try {
            fieldValue = getter.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        boolean b = fieldValue == null ? false : (Boolean)fieldValue;
        Label label = new Label(componentId);
        cellItem.add(new Component[]{label});
        if (b) {
            label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"replaced enabled")), " ")});
        }
    }
}

