/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.dashboardpanel;

import com.google.common.base.Objects;
import com.pmease.quickbuild.util.StringUtils;
import java.awt.Color;
import java.io.Serializable;
import java.text.NumberFormat;

public class StatsData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private String color;
    private String title;

    public StatsData() {
    }

    public StatsData(String title, String color, double data) {
        this.title = title;
        this.color = color;
        this.value = data;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object data) {
        this.value = data;
    }

    public String getColor() {
        if (StringUtils.isEmpty((String)this.color)) {
            return null;
        }
        if (!this.color.startsWith("#")) {
            return "#" + this.color;
        }
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String formatData() {
        NumberFormat format = NumberFormat.getInstance();
        return format.format(this.value);
    }

    public Color getAWTColor() {
        if (this.color == null) {
            return null;
        }
        String nm = this.color;
        if (nm.startsWith("#")) {
            nm = nm.substring(1);
        }
        nm = "0x" + nm;
        return Color.decode(nm);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.color, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof StatsData)) {
            return false;
        }
        StatsData rhs = (StatsData)obj;
        return Objects.equal((Object)this.title, (Object)rhs.title) && Objects.equal((Object)this.color, (Object)rhs.color) && Objects.equal((Object)this.value, (Object)rhs.value);
    }
}

