/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.dashboardpanel;

import com.pmease.quickbuild.web.chart.ChartUtils;
import com.pmease.quickbuild.web.chart.JFreeChartPanel;
import com.pmease.quickbuild.web.component.dashboardpanel.PieChartLegendPanel;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChartModulePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private String noDataMessage;

    public PieChartModulePanel(String id, int width, int height, String noDataMessage, boolean withLegend, IModel model) {
        super(id, model);
        this.noDataMessage = noDataMessage;
        this.add(new Component[]{new JFreeChartPanel("pieChart", width, height, (IModel<JFreeChart>)new PieChartModel())});
        if (withLegend) {
            this.add(new Component[]{this.createLegends("legends")});
        } else {
            this.add(new Component[]{new WebMarkupContainer("legends").setVisible(false)});
        }
        this.setOutputMarkupId(true);
    }

    public PieChartModulePanel(String id, int width, int height, boolean withLegend, IModel model) {
        this(id, width, height, null, withLegend, model);
    }

    public PieChartModulePanel(String id, IModel model, String noDataMessage) {
        this(id, 145, 140, true, model);
    }

    public PieChartModulePanel(String id, IModel model) {
        this(id, model, null);
    }

    protected Component createLegends(String id) {
        return new PieChartLegendPanel(id, (IModel<List<StatsData>>)this.getDefaultModel());
    }

    protected List<StatsData> getChartData() {
        return (List)this.getDefaultModelObject();
    }

    private PieDataset getDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<StatsData> data = this.getChartData();
        for (StatsData datum : data) {
            try {
                dataset.setValue((Comparable)((Object)datum.getTitle()), ((Number)datum.getValue()).doubleValue());
            }
            catch (Exception e) {
                dataset.setValue((Comparable)((Object)datum.getTitle()), 0.0);
            }
        }
        return dataset;
    }

    private class PieChartModel
    extends LoadableDetachableModel {
        private static final long serialVersionUID = 1L;

        private PieChartModel() {
        }

        protected Object load() {
            JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)PieChartModulePanel.this.getDataset(), (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            PiePlot plot = (PiePlot)chart.getPlot();
            ChartUtils.initDefaultPieChart(plot);
            List<StatsData> data = PieChartModulePanel.this.getChartData();
            for (StatsData datum : data) {
                plot.setSectionPaint((Comparable)((Object)datum.getTitle()), (Paint)datum.getAWTColor());
            }
            if (!StringUtils.isEmpty((String)PieChartModulePanel.this.noDataMessage)) {
                plot.setNoDataMessage(PieChartModulePanel.this.noDataMessage);
            }
            return chart;
        }
    }
}

