/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.dashboardpanel;

import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PieChartLegendPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public PieChartLegendPanel(String id, IModel<List<StatsData>> model) {
        super(id, model);
        this.add(new Component[]{new ListView<StatsData>(id, model){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<StatsData> item) {
                StatsData data = (StatsData)item.getModelObject();
                WebMarkupContainer colorContainer = new WebMarkupContainer("legendColor");
                colorContainer.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)("background: " + data.getColor()))), " ")});
                item.add(new Component[]{colorContainer});
                item.add(new Component[]{new Label("legendTitle", data.getTitle())});
                item.add(new Component[]{new Label("legendData", PieChartLegendPanel.this.formatLegend(data))});
                Component extra = PieChartLegendPanel.this.createExtraInfo("extraInfo", data);
                if (extra == null) {
                    item.add(new Component[]{new WebMarkupContainer("extraInfo").setVisible(false)});
                } else {
                    item.add(new Component[]{extra});
                }
            }
        }});
    }

    protected Component createExtraInfo(String id, StatsData data) {
        return null;
    }

    protected String formatLegend(StatsData data) {
        List<StatsData> all = this.getChartData();
        double totals = 0.0;
        for (StatsData each : all) {
            totals += ((Number)each.getValue()).doubleValue();
        }
        double percent = totals == 0.0 ? 0.0 : ((Number)data.getValue()).doubleValue() / totals;
        String result = data.formatData();
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        result = result + " (" + percentFormat.format(percent) + ")";
        return result;
    }

    protected List<StatsData> getChartData() {
        return (List)this.getDefaultModelObject();
    }
}

