/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.dashboardpanel;

import com.pmease.quickbuild.web.component.dashboardpanel.AbstractDashboardModulePanel;
import com.pmease.quickbuild.web.component.dashboardpanel.BaseDashboardModulePanel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class DashboardOverviewPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String MODULE_PANEL_ID = "module";
    private IModel modulesModel;

    public DashboardOverviewPanel(String id) {
        super(id);
        this.modulesModel = new LoadableDetachableModel(){
            private static final long serialVersionUID = 1L;

            protected Object load() {
                return DashboardOverviewPanel.this.getOverviewModules();
            }
        };
        this.addModules();
    }

    public DashboardOverviewPanel(String id, IModel modulesModel) {
        super(id);
        this.modulesModel = modulesModel;
    }

    public DashboardOverviewPanel(String id, AbstractDashboardModulePanel[] modules) {
        this(id, null, modules);
    }

    public DashboardOverviewPanel(String id, IModel model, AbstractDashboardModulePanel[] modules) {
        super(id, model);
        this.modulesModel = new Model((Serializable)((Object)Arrays.asList(modules)));
        this.addModules();
    }

    protected List<AbstractDashboardModulePanel> getOverviewModules() {
        return Collections.emptyList();
    }

    public void addModules() {
        List modules = (List)this.modulesModel.getObject();
        final double percent = modules.size() == 1 ? 1.0 : (0.99 - 0.01 * (double)(modules.size() - 1)) / (double)modules.size();
        final int last = modules.size() - 1;
        ListView listView = new ListView("modules", modules){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem item) {
                BaseDashboardModulePanel panel = (BaseDashboardModulePanel)((Object)item.getModelObject());
                String style = "width: " + String.valueOf(percent * 100.0) + "%;";
                style = item.getIndex() == last ? style + "float: right; margin-right: 0pt;" : style + "float: left; margin-right: 1%;";
                item.add(new Behavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)style)), " ")});
                item.add(new Component[]{panel});
            }
        };
        listView.add(new Behavior[]{new AttributeAppender("class", (IModel)new AbstractReadOnlyModel(){
            private static final long serialVersionUID = 1L;

            public Object getObject() {
                String css = DashboardOverviewPanel.this.getCssClass();
                if (StringUtils.isEmpty((String)css)) {
                    return "";
                }
                return DashboardOverviewPanel.this.getCssClass();
            }
        }, " ")});
        this.add(new Component[]{listView});
    }

    protected String getCssClass() {
        return null;
    }

    public void onDetach() {
        super.onDetach();
        if (this.modulesModel != null) {
            this.modulesModel.detach();
        }
    }
}

