/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import javax.annotation.Nullable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class InheritIndicator
extends Panel {
    private IModel<Configuration> declareConfigurationModel;
    private IModel<Configuration> overrideConfigurationModel;

    public InheritIndicator(String id, Configuration declarer, @Nullable Configuration override, @Nullable String settingName) {
        super(id);
        final Long declareConfigurationId = declarer.getId();
        final Long overrideConfigurationId = override != null ? override.getId() : null;
        this.declareConfigurationModel = new LoadableDetachableModel<Configuration>(){

            protected Configuration load() {
                return (Configuration)ConfigurationManager.instance.load(declareConfigurationId);
            }
        };
        this.overrideConfigurationModel = new LoadableDetachableModel<Configuration>(){

            protected Configuration load() {
                if (overrideConfigurationId != null) {
                    return (Configuration)ConfigurationManager.instance.load(overrideConfigurationId);
                }
                return null;
            }
        };
        final boolean authorized = settingName != null ? (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null ? SecurityHelper.hasPermission(this.getOverrideConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name()) : SecurityHelper.hasPermission(this.getDeclareConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) : (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null ? SecurityHelper.hasPermission(this.getOverrideConfiguration()) : SecurityHelper.hasPermission(this.getDeclareConfiguration()));
        BookmarkablePageLink link = settingName != null ? (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null ? new BookmarkablePageLink("link", ConfigurationSettingPage.class, ConfigurationSettingPage.params4(this.getOverrideConfiguration().getId(), settingName)) : new BookmarkablePageLink("link", ConfigurationSettingPage.class, ConfigurationSettingPage.params4(this.getDeclareConfiguration().getId(), settingName))) : (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null ? new BookmarkablePageLink("link", ConfigurationOverview.class, ConfigurationOverview.params4(this.getOverrideConfiguration().getId())) : new BookmarkablePageLink("link", ConfigurationOverview.class, ConfigurationOverview.params4(this.getDeclareConfiguration().getId())));
        this.add(new Component[]{link});
        link.setEnabled(authorized);
        link.add(new Component[]{new WebMarkupContainer("icon"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (authorized) {
                    if (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null) {
                        tag.put("src", (CharSequence)"/images/override.png");
                        tag.put("title", (CharSequence)("Click to visit '" + InheritIndicator.this.getOverrideConfiguration().getPathName() + "' whose setting is overriden."));
                    } else {
                        tag.put("src", (CharSequence)"/images/inherit.gif");
                        tag.put("title", (CharSequence)("Click to visit '" + InheritIndicator.this.getDeclareConfiguration().getPathName() + "' from which this setting is inherited."));
                    }
                } else if (declareConfigurationId.equals(Context.getConfiguration().getId()) && overrideConfigurationId != null) {
                    tag.put("src", (CharSequence)"/images/override-disabled.png");
                    tag.put("title", (CharSequence)("This setting overrides setting defined in '" + InheritIndicator.this.getOverrideConfiguration().getPathName() + "'."));
                } else {
                    tag.put("src", (CharSequence)"/images/inherit-disabled.gif");
                    tag.put("title", (CharSequence)("This setting is inherited from '" + InheritIndicator.this.getDeclareConfiguration().getPathName() + "'"));
                }
            }
        }});
        if (this.getDeclareConfiguration().getId().equals(Context.getConfiguration().getId()) && overrideConfigurationId == null) {
            this.setVisible(false);
        }
    }

    private Configuration getDeclareConfiguration() {
        return (Configuration)this.declareConfigurationModel.getObject();
    }

    private Configuration getOverrideConfiguration() {
        return (Configuration)this.overrideConfigurationModel.getObject();
    }

    public void detachModels() {
        this.declareConfigurationModel.detach();
        this.overrideConfigurationModel.detach();
        super.detachModels();
    }
}

