/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.taskschedule.schedule.NoSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.build.HistoryBuildsPage;
import com.pmease.quickbuild.web.page.configuration.BuildOptionEdit;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;

public class ConfigurationTreeView
extends Panel {
    private TreeTable treeTable;
    private IModel<Map<Long, Integer>> buildRequestCountMapModel = new LoadableDetachableModel<Map<Long, Integer>>(){

        protected Map<Long, Integer> load() {
            return BuildEngine.instance.getBuildRequestCountAsMap();
        }
    };

    public ConfigurationTreeView(String id, final Long treeRootId, boolean displayTreeRoot, boolean displaySchedule, boolean displayRequestCount, boolean displayHistoryCount) {
        super(id);
        ArrayList<TreeTableColumn> columns = new ArrayList<TreeTableColumn>();
        if (displaySchedule) {
            columns.add(new TreeTableColumn(){

                @Override
                public Component newCell(String id, final Serializable nodeKey) {
                    Object link;
                    Label label;
                    final Fragment fragment = new Fragment(id, "scheduleFrag", (MarkupContainer)ConfigurationTreeView.this);
                    Configuration configuration = BasePage.get().getConfigurations().get((Long)nodeKey);
                    Schedule schedule = configuration.getSchedule();
                    if (schedule == null) {
                        label = new Label("info", "<i>Inherit from parent</i>");
                        label.setRenderBodyOnly(true);
                        link = new WebMarkupContainer("link");
                        link.add(new Component[]{new WebMarkupContainer("icon")});
                    } else if (schedule instanceof NoSchedule) {
                        label = new Label("info", "No schedule");
                        label.setRenderBodyOnly(true);
                        link = new WebMarkupContainer("link");
                        link.add(new Component[]{new WebMarkupContainer("icon")});
                    } else {
                        label = new Label("info", (IModel)new AbstractReadOnlyModel<String>(){

                            public String getObject() {
                                Configuration cached = CacheManager.instance.getConfiguration((Long)nodeKey);
                                if (cached.getSchedule() != null) {
                                    if (cached.getSchedule().isPaused()) {
                                        return cached.getSchedule().toString() + " (paused)";
                                    }
                                    return cached.getSchedule().toString();
                                }
                                return "<i>Inherit from parent</i>";
                            }
                        }){

                            protected void onComponentTag(ComponentTag tag) {
                                super.onComponentTag(tag);
                                Configuration cached = CacheManager.instance.getConfiguration((Long)nodeKey);
                                if (cached != null && cached.getSchedule() != null) {
                                    if (cached.getSchedule().isPaused()) {
                                        tag.put("class", (CharSequence)"red");
                                    } else {
                                        tag.put("class", (CharSequence)"green");
                                    }
                                }
                            }
                        };
                        label.setOutputMarkupId(true);
                        link = new IndicatingAjaxLink<Void>("link"){

                            public void onClick(AjaxRequestTarget target) {
                                Configuration reloaded = (Configuration)ConfigurationManager.instance.load((Long)nodeKey);
                                if (reloaded.getSchedule() != null) {
                                    String previousContent = VersionedDocument.fromBean(reloaded.getSchedule()).toXML();
                                    reloaded.getSchedule().setPaused(!reloaded.getSchedule().isPaused());
                                    ConfigurationManager.instance.saveSchedule(reloaded);
                                    AuditManager.instance.audit(reloaded, "Schedule status is changed.", VersionedDocument.fromBean(reloaded.getSchedule()).toXML(), previousContent);
                                    target.add(fragment.get("info"), fragment.get("link"));
                                }
                            }

                            protected void onComponentTag(ComponentTag tag) {
                                super.onComponentTag(tag);
                                Configuration cached = CacheManager.instance.getConfiguration((Long)nodeKey);
                                if (cached != null && cached.getSchedule() != null) {
                                    if (cached.getSchedule().isPaused()) {
                                        tag.put("title", (CharSequence)"Schedule paused, click to resume");
                                    } else {
                                        tag.put("title", (CharSequence)"Scheduled, click to pause");
                                    }
                                    if (cached.getSchedule().isPaused()) {
                                        tag.put("src", (CharSequence)"/images/play.gif");
                                    } else {
                                        tag.put("src", (CharSequence)"/images/pause.gif");
                                    }
                                } else {
                                    tag.put("src", (CharSequence)"/images/warning.gif");
                                }
                            }
                        };
                        link.setOutputMarkupId(true);
                    }
                    if (schedule == null || schedule instanceof NoSchedule || !SecurityHelper.isEditSettingAllowed(configuration)) {
                        link.setVisible(false);
                    }
                    fragment.add(new Component[]{link});
                    label.setEscapeModelStrings(false);
                    fragment.add(new Component[]{label});
                    return fragment;
                }

                @Override
                public Component newHeader(String id) {
                    return new Label(id, "Schedule");
                }
            });
        }
        if (displayHistoryCount) {
            columns.add(new TreeTableColumn(){

                @Override
                public Component newCell(String id, final Serializable nodeKey) {
                    Fragment fragment = new Fragment(id, "historyFrag", (MarkupContainer)ConfigurationTreeView.this);
                    BookmarkablePageLink link = new BookmarkablePageLink("link", HistoryBuildsPage.class, HistoryBuildsPage.params4((Long)nodeKey, null));
                    final Label label = new Label("label", (IModel)new Model((Serializable)Long.valueOf(CacheManager.instance.getHistoryCount((Long)nodeKey))));
                    label.add(new Behavior[]{new RefreshBehavior(){

                        @Override
                        public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                            Long historyCount = CacheManager.instance.getHistoryCount((Long)nodeKey);
                            if (!historyCount.equals(label.getDefaultModelObject())) {
                                label.setDefaultModel((IModel)new Model((Serializable)historyCount));
                                return true;
                            }
                            return false;
                        }
                    }});
                    link.add(new Component[]{label});
                    fragment.add(new Component[]{link});
                    return fragment;
                }

                @Override
                public Component newHeader(String id) {
                    return new Label(id, "#Builds");
                }
            });
        }
        if (displayRequestCount) {
            columns.add(new TreeTableColumn(){

                @Override
                public Component newCell(String id, final Serializable nodeKey) {
                    Fragment fragment = new Fragment(id, "configurationLinkFrag", (MarkupContainer)ConfigurationTreeView.this);
                    BookmarkablePageLink link = new BookmarkablePageLink("link", ConfigurationOverview.class, ConfigurationPage.params4((Long)nodeKey));
                    fragment.add(new Component[]{link});
                    Label label = new Label("label", (IModel)new LoadableDetachableModel<String>(){

                        protected String load() {
                            Integer count = (Integer)ConfigurationTreeView.this.getBuildRequestCountMap().get(nodeKey);
                            if (count == null) {
                                count = 0;
                            }
                            return String.valueOf(count);
                        }
                    });
                    label.add(new Behavior[]{new RefreshBehavior(){

                        @Override
                        public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                            return BuildEngine.instance.getActivityDate((Long)nodeKey).after(lastRefreshDate);
                        }
                    }});
                    link.add(new Component[]{label});
                    return fragment;
                }

                @Override
                public Component newHeader(String id) {
                    return new Label(id, "#Requests");
                }
            });
        }
        columns.add(new TreeTableColumn(){

            @Override
            public Component newHeader(String id) {
                return new Label(id, "Latest build");
            }

            @Override
            public Component newCell(String id, final Serializable nodeKey) {
                return new BuildInfoPanel(id, (IModel<Build>)new LoadableDetachableModel<Build>(){

                    protected Build load() {
                        Configuration configuration = BasePage.get().getConfigurations().get((Long)nodeKey);
                        Build build = CacheManager.instance.cloneLatestBuild(configuration.getId());
                        if (build != null) {
                            build.setConfiguration(configuration);
                        }
                        return build;
                    }
                });
            }
        });
        TreeTableColumn treeColumn = new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                final Long configurationId = (Long)nodeKey;
                Fragment fragment = new Fragment(id, "nodeFrag", (MarkupContainer)ConfigurationTreeView.this);
                fragment.add(new Component[]{new ConfigurationStatusPanel("status", configurationId)});
                BookmarkablePageLink link = new BookmarkablePageLink("link", ConfigurationOverview.class, ConfigurationPage.params4(configurationId));
                Configuration configuration = BasePage.get().getConfigurations().get(configurationId);
                Label label = new Label("label", configuration.getDisplayName(BasePage.get().getConfigurations().get(treeRootId)));
                label.setRenderBodyOnly(true);
                link.add(new Component[]{label});
                fragment.add(new Component[]{link});
                PageParameters params = ConfigurationSettingPage.params4(configurationId, "general");
                fragment.add(new Component[]{new BookmarkablePageLink("settings", ConfigurationSettingPage.class, params)});
                fragment.get("settings").setVisible(SecurityHelper.hasPermission(configuration, ConfigurationPermission.ACCESS_SETTINGS.name()));
                fragment.add(new Component[]{new Link<Void>("run"){

                    public void onClick() {
                        Configuration reloaded = (Configuration)ConfigurationManager.instance.load(configurationId);
                        if (VariableBeanHelper.hasPromptFields(reloaded.getVariablePromptBeanClass())) {
                            this.setResponsePage((Page)new BuildOptionEdit(configurationId, new PageBack(){

                                @Override
                                public void go() {
                                    this.setResponsePage(DashboardPage.class);
                                }
                            }));
                        } else {
                            BuildRequest request = new BuildRequest();
                            request.setConfigurationId(configurationId);
                            request.setRespectBuildCondition(false);
                            Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
                            RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
                            if (result.getRequestId() != null) {
                                if (configuration.findAuditBuildRequest().booleanValue()) {
                                    AuditManager.instance.audit(configuration, "Build was requested.");
                                }
                                this.getSession().info((Serializable)((Object)"Build request has been queued."));
                            } else {
                                this.getSession().warn((Serializable)((Object)result.getRejectReason()));
                            }
                            this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(configurationId));
                        }
                    }
                }});
                fragment.get("run").setVisible(!configuration.isDisabled() && SecurityHelper.hasPermission(configuration, ConfigurationPermission.RUN_BUILD.name()));
                return fragment;
            }

            @Override
            public Component newHeader(String id) {
                Fragment fragment = new Fragment(id, "headerFrag", (MarkupContainer)ConfigurationTreeView.this);
                fragment.add(new Component[]{new IndicatingAjaxLink<Void>("expand"){

                    public void onClick(AjaxRequestTarget target) {
                        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
                            if (configuration.getParent() == null) continue;
                            ConfigurationTreeView.this.getState().setExpanded(configuration.getParent().getId(), true);
                        }
                        target.add(new Component[]{ConfigurationTreeView.this.treeTable});
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isExpandAllAllowed());
                    }
                }});
                fragment.add(new Component[]{new IndicatingAjaxLink<Void>("collapse"){

                    public void onClick(AjaxRequestTarget target) {
                        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
                            ConfigurationTreeView.this.getState().setExpanded(configuration.getId(), false);
                        }
                        target.add(new Component[]{ConfigurationTreeView.this.treeTable});
                    }
                }});
                return fragment;
            }
        };
        Component[] componentArray = new Component[1];
        this.treeTable = new ConfigurationTreeTable("treeTable", treeRootId, displayTreeRoot, this.getState(), treeColumn, columns.toArray(new TreeTableColumn[columns.size()]));
        componentArray[0] = this.treeTable;
        this.add(componentArray);
        this.treeTable.setOutputMarkupId(true);
    }

    private TreeState getState() {
        return new TreeState(){

            @Override
            public boolean isExpanded(Serializable nodeKey) {
                return WebSession.get().getConfigurationTreeViewState().isExpanded(nodeKey);
            }

            @Override
            public void setExpanded(Serializable nodeKey, boolean expanded) {
                WebSession.get().getConfigurationTreeViewState().setExpanded(nodeKey, expanded);
            }
        };
    }

    private Map<Long, Integer> getBuildRequestCountMap() {
        return (Map)this.buildRequestCountMapModel.getObject();
    }

    protected void detachModel() {
        this.buildRequestCountMapModel.detach();
        super.detachModel();
    }
}

