/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.treetable.TreeDataProvider;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfigurationTreeTable
extends TreeTable {
    public ConfigurationTreeTable(String id, Long treeRootId, boolean displayTreeRoot, TreeState state, TreeTableColumn treeColumn, TreeTableColumn[] additionalColumns) {
        super(id, new ConfigurationTreeDataProvider(treeRootId, displayTreeRoot), state, treeColumn, additionalColumns, false);
    }

    private static class ConfigurationTreeDataProvider
    implements TreeDataProvider {
        private Long treeRootId;
        private boolean displayTreeRoot;

        public ConfigurationTreeDataProvider(Long treeRootId, boolean displayTreeRoot) {
            this.treeRootId = treeRootId;
            this.displayTreeRoot = displayTreeRoot;
        }

        private Configuration getTreeRoot() {
            return BasePage.get().getConfigurations().get(this.treeRootId);
        }

        @Override
        public List<Serializable> getChildNodeKeys(Serializable nodeKey) {
            ArrayList<Configuration> childConfs = new ArrayList<Configuration>();
            for (Configuration each : BasePage.get().getConfigurations().values()) {
                if (each.getParent() == null || !each.getParent().getId().equals(nodeKey)) continue;
                childConfs.add(each);
            }
            Collections.sort(childConfs, new Comparator<Serializable>(){

                @Override
                public int compare(Serializable o1, Serializable o2) {
                    Configuration configuration1 = (Configuration)o1;
                    Configuration configuration2 = (Configuration)o2;
                    return configuration1.getName().compareTo(configuration2.getName());
                }
            });
            ArrayList<Serializable> children = new ArrayList<Serializable>();
            for (Configuration each : childConfs) {
                children.add(each.getId());
            }
            return children;
        }

        @Override
        public Serializable getParentNodeKey(Serializable nodeKey) {
            Long configurationId = (Long)nodeKey;
            if (configurationId.equals(this.treeRootId)) {
                return null;
            }
            Configuration parent = BasePage.get().getConfigurations().get(configurationId).getParent();
            if (parent == null || !this.displayTreeRoot && parent.getId().equals(this.treeRootId) || !SecurityHelper.hasPermission(parent)) {
                return null;
            }
            return parent;
        }

        private List<Configuration> getAuthorizedRoots() {
            CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
            HashSet<Long> authorizedConfigurationIds = new HashSet<Long>();
            ArrayList<Configuration> authorizedRoots = new ArrayList<Configuration>();
            User user = Context.getUser();
            ArrayList<Group> groups = new ArrayList<Group>();
            if (user == null) {
                Group anonymousGroup = cacheManager.getGroup("anonymous");
                if (anonymousGroup != null) {
                    groups.add(anonymousGroup);
                }
            } else {
                if (user.isRoot()) {
                    authorizedRoots.add(BasePage.get().getConfigurations().get(Configuration.ROOT_ID));
                    return authorizedRoots;
                }
                groups.addAll(cacheManager.getGroups(user.getId()));
            }
            for (Group group : groups) {
                if (group.isAdmin()) {
                    authorizedRoots.add(BasePage.get().getConfigurations().get(Configuration.ROOT_ID));
                    return authorizedRoots;
                }
                for (Authorization authorization : cacheManager.getAuthorizations(group.getId())) {
                    authorizedConfigurationIds.add(authorization.getConfiguration().getId());
                }
            }
            for (Configuration configuration : BasePage.get().getConfigurations().values()) {
                if (!this.isTopAuthorized(configuration, authorizedConfigurationIds)) continue;
                authorizedRoots.add(configuration);
            }
            return authorizedRoots;
        }

        @Override
        public List<Serializable> getRootNodeKeys() {
            ArrayList<Configuration> rootNodes = new ArrayList<Configuration>();
            Configuration treeRoot = this.getTreeRoot();
            for (Configuration eachKey : this.getAuthorizedRoots()) {
                Configuration configuration = eachKey;
                if (treeRoot.getInheritDistance(configuration) != -1) {
                    if (!this.displayTreeRoot) {
                        for (Configuration eachConf : BasePage.get().getConfigurations().values()) {
                            if (eachConf.getParent() == null || !eachConf.getParent().getId().equals(treeRoot.getId())) continue;
                            rootNodes.add(eachConf);
                        }
                        break;
                    }
                    rootNodes.add(treeRoot);
                    break;
                }
                if (configuration.getInheritDistance(treeRoot) <= 0) continue;
                rootNodes.add(configuration);
            }
            Collections.sort(rootNodes, new Comparator<Configuration>(){

                @Override
                public int compare(Configuration o1, Configuration o2) {
                    return o1.getPathName().compareTo(o2.getPathName());
                }
            });
            ArrayList<Serializable> rootNodeKeys = new ArrayList<Serializable>();
            for (Configuration each : rootNodes) {
                rootNodeKeys.add(each.getId());
            }
            return rootNodeKeys;
        }

        private boolean isTopAuthorized(Configuration configuration, Set<Long> authorized) {
            if (authorized.contains(configuration.getId())) {
                for (Configuration parent = configuration.getParent(); parent != null; parent = parent.getParent()) {
                    if (!authorized.contains(parent.getId())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isExpandable(Serializable nodeKey) {
            for (Configuration each : BasePage.get().getConfigurations().values()) {
                if (each.getParent() == null || !each.getParent().getId().equals(nodeKey)) continue;
                return true;
            }
            return false;
        }
    }
}

