/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class ConfigurationSubordinateChooser
extends Panel {
    private ConfigurationTreeTable configurationTreeTable;
    private String selectedObjectName;

    public ConfigurationSubordinateChooser(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.configurationTreeTable = new ConfigurationTreeTable("configurationTreeTable", Configuration.ROOT_ID, true, this.getState(), new TreeTableColumn(){

            @Override
            public Component newCell(String id, final Serializable nodeKey) {
                Configuration configuration = (Configuration)ConfigurationManager.instance.load((Long)nodeKey);
                Fragment fragment = new Fragment(id, "nodeFrag", (MarkupContainer)ConfigurationSubordinateChooser.this);
                fragment.add(new Component[]{new ConfigurationStatusPanel("status", configuration.getId())});
                fragment.add(new Component[]{new Label("name", configuration.getDisplayName(null))});
                List<String> objectNames = ConfigurationSubordinateChooser.this.getSubordinateNames(configuration);
                DropDownChoice<String> dropdown = new DropDownChoice<String>("select", (IModel)new IModel<String>(){

                    public String getObject() {
                        return ConfigurationSubordinateChooser.this.selectedObjectName;
                    }

                    public void setObject(String object) {
                        ConfigurationSubordinateChooser.this.selectedObjectName = object;
                    }

                    public void detach() {
                    }
                }, objectNames){

                    protected boolean wantOnSelectionChangedNotifications() {
                        return true;
                    }

                    protected void onSelectionChanged(String newSelection) {
                        Configuration configuration = (Configuration)ConfigurationManager.instance.load((Long)nodeKey);
                        ConfigurationSubordinateChooser.this.subordinateSelected(configuration, newSelection);
                    }
                };
                dropdown.setVisible(!objectNames.isEmpty());
                dropdown.setNullValid(false);
                fragment.add(new Component[]{dropdown});
                return fragment;
            }

            @Override
            public Component newHeader(String id) {
                Fragment fragment = new Fragment(id, "headerFrag", (MarkupContainer)ConfigurationSubordinateChooser.this);
                fragment.add(new Component[]{new IndicatingAjaxLink<Void>("expandAllLink"){

                    public void onClick(AjaxRequestTarget target) {
                        ConfigurationSubordinateChooser.this.expandAll();
                        target.add(new Component[]{ConfigurationSubordinateChooser.this.configurationTreeTable});
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.isExpandAllAllowed());
                    }
                }});
                fragment.add(new Component[]{new IndicatingAjaxLink<Void>("collapseAllLink"){

                    public void onClick(AjaxRequestTarget target) {
                        ConfigurationSubordinateChooser.this.collapseAll();
                        target.add(new Component[]{ConfigurationSubordinateChooser.this.configurationTreeTable});
                    }
                }});
                return fragment;
            }
        }, new TreeTableColumn[0]);
        componentArray[0] = this.configurationTreeTable;
        this.add(componentArray);
    }

    private TreeState getState() {
        return new TreeState(){

            @Override
            public boolean isExpanded(Serializable nodeKey) {
                return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
            }

            @Override
            public void setExpanded(Serializable nodeKey, boolean expanded) {
                WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
            }
        };
    }

    public void expandAll() {
        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
            if (configuration.getParent() == null) continue;
            this.getState().setExpanded(configuration.getParent().getId(), true);
        }
    }

    public void collapseAll() {
        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
            this.getState().setExpanded(configuration.getId(), false);
        }
    }

    protected abstract List<String> getSubordinateNames(Configuration var1);

    protected abstract void subordinateSelected(Configuration var1, String var2);
}

