/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;

public class ConfigurationStatusPanel
extends Panel {
    public ConfigurationStatusPanel(String id, final Long configurationId) {
        super(id);
        this.setOutputMarkupId(true);
        this.add(new Component[]{new InternalImage("icon", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                Configuration cached = CacheManager.instance.getConfiguration(configurationId);
                if (cached != null) {
                    if (cached.getErrorMessage() != null) {
                        return "/images/configuration-error.png";
                    }
                    return "/images/configuration.png";
                }
                return "/images/warning.gif";
            }
        }){

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Configuration cached = CacheManager.instance.getConfiguration(configurationId);
                if (cached != null) {
                    if (cached.getErrorMessage() != null) {
                        tag.put("title", (CharSequence)"Configuration is in error. Visit configuration overview tab for details");
                    } else {
                        tag.put("title", (CharSequence)"Current configuration");
                    }
                } else {
                    tag.put("title", (CharSequence)"Configuration is not in cache");
                }
            }
        }});
        this.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Configuration cached = CacheManager.instance.getConfiguration(configurationId);
                return cached != null && cached.getStatusDate().after(lastRefreshDate);
            }
        }});
    }
}

