/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.configuration;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class ConfigurationChooser
extends Panel {
    private ConfigurationTreeTable treeTable;
    private Long treeRootId;

    public ConfigurationChooser(String id, Long treeRootId, boolean displayTreeRoot, TreeState state) {
        super(id);
        this.treeRootId = treeRootId;
        Component[] componentArray = new Component[1];
        this.treeTable = new ConfigurationTreeTable("treeTable", treeRootId, displayTreeRoot, state, new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                Configuration configuration = (Configuration)ConfigurationManager.instance.load((Long)nodeKey);
                return new NodePanel(id, configuration);
            }

            @Override
            public Component newHeader(String id) {
                return new HeaderPanel(id);
            }
        }, new TreeTableColumn[0]);
        componentArray[0] = this.treeTable;
        this.add(componentArray);
        this.treeTable.setOutputMarkupId(true);
        this.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"configuration-chooser"))});
    }

    public void reveal(Configuration configuration) {
        while (configuration.getParent() != null) {
            this.treeTable.getState().setExpanded(configuration.getParent().getId(), true);
            configuration = configuration.getParent();
        }
    }

    public void expandAll() {
        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
            if (configuration.getParent() == null) continue;
            this.treeTable.getState().setExpanded(configuration.getParent().getId(), true);
        }
    }

    public void collapseAll() {
        for (Configuration configuration : BasePage.get().getConfigurations().values()) {
            this.treeTable.getState().setExpanded(configuration.getId(), false);
        }
    }

    protected boolean isRevealLinkVisible() {
        return false;
    }

    protected abstract WebMarkupContainer newSelectLink(String var1, Configuration var2);

    Configuration getTreeRoot() {
        return (Configuration)ConfigurationManager.instance.load(this.treeRootId);
    }

    private class NodePanel
    extends Fragment {
        public NodePanel(String id, Configuration configuration) {
            super(id, "nodeFrag", (MarkupContainer)ConfigurationChooser.this);
            this.add(new Component[]{new ConfigurationStatusPanel("status", configuration.getId())});
            WebMarkupContainer link = ConfigurationChooser.this.newSelectLink("select", configuration);
            String cssClasses = "node";
            if (link instanceof Link) {
                cssClasses = cssClasses + " maskable";
            }
            if (ConfigurationChooser.this.isRevealLinkVisible() && configuration.getId().equals(Context.getConfiguration().getId())) {
                cssClasses = cssClasses + " selected";
            }
            link.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)cssClasses))});
            this.add(new Component[]{link});
            link.add(new Component[]{new Label("name", configuration.getDisplayName(ConfigurationChooser.this.getTreeRoot()))});
        }
    }

    private class HeaderPanel
    extends Fragment {
        public HeaderPanel(String id) {
            super(id, "headerFrag", (MarkupContainer)ConfigurationChooser.this);
            this.add(new Component[]{new IndicatingAjaxLink<Void>("expandAllLink"){

                public void onClick(AjaxRequestTarget target) {
                    ConfigurationChooser.this.expandAll();
                    target.add(new Component[]{ConfigurationChooser.this.treeTable});
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(SecurityHelper.isExpandAllAllowed());
                }
            }});
            this.add(new Component[]{new IndicatingAjaxLink<Void>("collapseAllLink"){

                public void onClick(AjaxRequestTarget target) {
                    ConfigurationChooser.this.collapseAll();
                    target.add(new Component[]{ConfigurationChooser.this.treeTable});
                }
            }});
            this.add(new Component[]{new IndicatingAjaxLink<Void>("revealLink"){

                public void onClick(AjaxRequestTarget target) {
                    ConfigurationChooser.this.reveal(Context.getConfiguration());
                    target.add(new Component[]{ConfigurationChooser.this.treeTable});
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(ConfigurationChooser.this.isRevealLinkVisible());
                }
            }});
        }
    }
}

