/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.ContextAware;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class MoreBuildInfoPanel
extends Panel
implements ContextAware {
    private Build build;

    public MoreBuildInfoPanel(String id, Build build) {
        super(id);
        this.build = build;
        this.add(new Component[]{new Label("id", (IModel)new Model((Serializable)build.getId()))});
        this.add(new Component[]{new Label("triggeredBy", build.getRequesterName())});
        this.add(new Component[]{new ListView<PanelCreator>("contributions", (IModel)new LoadableDetachableModel<List<PanelCreator>>(){

            protected List<PanelCreator> load() {
                ArrayList<BuildSummaryContribution> contributions = new ArrayList<BuildSummaryContribution>();
                for (BuildSummaryContribution contribution : PluginManager.instance.getExtensions(BuildSummaryContribution.class)) {
                    contributions.add(contribution);
                }
                Collections.sort(contributions, new Comparator<BuildSummaryContribution>(){

                    @Override
                    public int compare(BuildSummaryContribution contrib1, BuildSummaryContribution contrib2) {
                        return contrib1.getOrder() - contrib2.getOrder();
                    }
                });
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                for (BuildSummaryContribution contrib : contributions) {
                    List<PanelCreator> contribCreators = contrib.getPanelCreators();
                    if (contribCreators == null) continue;
                    creators.addAll(contribCreators);
                }
                return creators;
            }
        }){

            protected void populateItem(ListItem<PanelCreator> item) {
                item.add(new Component[]{((PanelCreator)item.getModelObject()).newPanel("panel")});
            }
        }});
    }

    @Override
    public Build getContext() {
        return this.build;
    }
}

