/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.visit.IVisit;

public abstract class BuildTextPanel
extends Panel {
    public BuildTextPanel(String id, IModel<Build> buildModel) {
        super(id, buildModel);
        Label label = new Label("text", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return BuildTextPanel.this.getText(BuildTextPanel.this.getBuild());
            }
        });
        this.add(new Component[]{label});
        label.add(new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(HibernateUtils.getId(BuildTextPanel.this.getBuild()));
                return pair != null && pair.getSecond().after(lastRefreshDate);
            }
        });
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }

    protected abstract String getText(Build var1);
}

