/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;

public class BuildStatusPanel
extends Panel {
    public BuildStatusPanel(String id, IModel<Build> buildModel) {
        super(id, buildModel);
        WebMarkupContainer icon = new WebMarkupContainer("icon"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (BuildStatusPanel.this.getBuild().getId() == null) {
                    tag.put("src", (CharSequence)"/images/hourglass.png");
                    tag.put("title", (CharSequence)"Build request is waiting to be processed");
                } else if (BuildStatusPanel.this.getBuild().getStatus() == Build.Status.RUNNING) {
                    tag.put("src", (CharSequence)"/images/spin-ball.gif");
                    tag.put("title", (CharSequence)"Build is running");
                } else if (BuildStatusPanel.this.getBuild().getStatus() == Build.Status.SUCCESSFUL) {
                    tag.put("src", (CharSequence)"/images/green-ball.gif");
                    tag.put("title", (CharSequence)"Build is successful");
                } else if (BuildStatusPanel.this.getBuild().getStatus() == Build.Status.CANCELLED) {
                    tag.put("src", (CharSequence)"/images/cancelled.gif");
                    tag.put("title", (CharSequence)"Build is cancelled");
                } else if (BuildStatusPanel.this.getBuild().getStatus() == Build.Status.TIMEOUT) {
                    tag.put("src", (CharSequence)"/images/timeout.gif");
                    tag.put("title", (CharSequence)"Build is timed out");
                } else if (BuildStatusPanel.this.getBuild().getStatus() == Build.Status.FAILED) {
                    tag.put("src", (CharSequence)"/images/red-ball.gif");
                    tag.put("title", (CharSequence)"Build is failed");
                } else {
                    tag.put("src", (CharSequence)"/images/star.gif");
                    tag.put("title", (CharSequence)"Build is recommended");
                }
            }
        };
        this.add(new Component[]{icon});
        icon.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Build build = BuildStatusPanel.this.getBuild();
                Long buildId = HibernateUtils.getId(build);
                if (buildId != null) {
                    Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(buildId);
                    return pair != null && pair.getSecond().after(lastRefreshDate);
                }
                return build.getStatusDate() != null && build.getStatusDate().after(lastRefreshDate);
            }
        }});
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }
}

