/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.ProgressBar;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.visit.IVisit;

public class BuildProgressBar
extends Panel {
    private IModel<Long> baseDurationModel = new LoadableDetachableModel<Long>(){

        protected Long load() {
            Build build = BuildEngine.instance.getBuild(HibernateUtils.getId(BuildProgressBar.this.getBuild()));
            if (build != null) {
                return CacheManager.instance.getBaseDuration(build.getConfiguration().getId());
            }
            return 0L;
        }
    };

    public BuildProgressBar(String id, IModel<Build> buildModel) {
        super(id, buildModel);
        this.add(new Component[]{new ProgressBar("progress", (IModel<Integer>)new LoadableDetachableModel<Integer>(){

            protected Integer load() {
                if (BuildProgressBar.this.getBaseDuration() != 0L) {
                    Build build = BuildEngine.instance.getBuild(HibernateUtils.getId(BuildProgressBar.this.getBuild()));
                    if (build != null) {
                        long duration = new Date().getTime() - build.getBeginDate().getTime();
                        int percentage = (int)Math.round((double)duration * 100.0 / (double)BuildProgressBar.this.getBaseDuration());
                        if (percentage > 100) {
                            percentage = 100;
                        }
                        if (percentage < 0) {
                            percentage = 0;
                        }
                        return new Integer(percentage);
                    }
                    return 100;
                }
                return 100;
            }
        })});
        this.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                return true;
            }
        }});
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(BuildEngine.instance.getBuild(HibernateUtils.getId(this.getBuild())) != null && this.getBaseDuration() != 0L);
    }

    private long getBaseDuration() {
        return (Long)this.baseDurationModel.getObject();
    }
}

