/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.build.BuildStatusPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class BuildListPanel
extends Panel {
    public BuildListPanel(String id, IModel<List<Build>> model) {
        super(id);
        this.add(new Component[]{new ListView("builds", model){

            protected void populateItem(final ListItem item) {
                Build build = (Build)item.getModelObject();
                item.add(new Component[]{new ConfigurationStatusPanel("configurationStatus", build.getConfiguration().getId())});
                Object link = new BookmarkablePageLink("configurationLink", ConfigurationOverview.class, ConfigurationPage.params4(build.getConfiguration().getId())){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setEnabled(SecurityHelper.hasPermission(Context.getUser(), ((Build)item.getModelObject()).getConfiguration()));
                    }
                };
                link.add(new Component[]{new Label("configurationPath", build.getConfiguration().getPathName())});
                item.add(new Component[]{link});
                item.add(new Component[]{new BuildStatusPanel("buildStatus", (IModel<Build>)new AbstractReadOnlyModel(){

                    public Object getObject() {
                        return BuildManager.instance.load(((Build)item.getModelObject()).getId());
                    }
                })});
                link = new Link("buildLink"){

                    public void onClick() {
                        this.setResponsePage(BuildPage.class, BuildPage.params4(((Build)item.getModelObject()).getId()));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setEnabled(SecurityHelper.hasPermission(Context.getUser(), ((Build)item.getModelObject()).getConfiguration()));
                    }
                };
                link.add(new Component[]{new Label("buildVersion", build.getVersion())});
                item.add(new Component[]{link});
            }
        }});
    }
}

