/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;

public class BuildLink
extends WebMarkupContainer {
    private boolean showConfiguration;
    private boolean usePipelineName;
    private int maxWidth;

    public BuildLink(String id, IModel<Build> buildModel, boolean showConfiguration, boolean usePipelineName, int maxWidth) {
        super(id, buildModel);
        this.showConfiguration = showConfiguration;
        this.usePipelineName = usePipelineName;
        this.maxWidth = maxWidth;
        this.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Build build = BuildLink.this.getBuild();
                Long buildId = HibernateUtils.getId(build);
                if (buildId != null) {
                    Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(buildId);
                    return pair != null && pair.getSecond().after(lastRefreshDate);
                }
                return build.getStatusDate() != null && build.getStatusDate().after(lastRefreshDate);
            }
        }});
    }

    public BuildLink(String id, IModel<Build> buildModel) {
        this(id, buildModel, false, false, 0);
    }

    public BuildLink(String id, IModel<Build> buildModel, boolean showConfiguration, boolean usePipelineName) {
        this(id, buildModel, showConfiguration, usePipelineName, 0);
    }

    protected void onComponentTag(ComponentTag tag) {
        String fullText;
        if (this.isEnabled()) {
            tag.setName("a");
        }
        super.onComponentTag(tag);
        Build build = this.getBuild();
        if (build.getStatus() != null) {
            tag.put("class", (CharSequence)("build-status " + this.getBuild().getStatus().name().toLowerCase()));
        }
        if (this.isEnabled()) {
            if (build.getId() != null) {
                tag.put("href", (CharSequence)("/build/" + build.getId()));
            } else {
                tag.put("href", (CharSequence)("/overview/" + build.getConfiguration().getId()));
            }
        }
        if (!this.abbreviate(fullText = this.getFullText()).equals(fullText)) {
            tag.put("title", (CharSequence)fullText);
        }
    }

    public void onConfigure() {
        super.onConfigure();
        this.setEnabled(SecurityHelper.hasPermission(this.getBuild().getConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullText() {
        Build build = this.getBuild();
        String text = build.getId() != null ? this.getBuild().getVersion() : (build.getErrorMessage() != null ? build.getErrorMessage() : " waiting...");
        if (this.showConfiguration) {
            if (this.usePipelineName) {
                String pipelineName = this.getBuild().getConfiguration().findPipelineName();
                Context.push(this.getBuild());
                try {
                    pipelineName = ScriptEngine.instance.interpolate(pipelineName, Context.buildEvalContext(this.getBuild().getConfiguration(), null));
                }
                finally {
                    Context.pop();
                }
                text = StringUtils.isNotBlank((String)pipelineName) ? pipelineName + ":" + text : this.getBuild().getConfiguration().getName() + ":" + text;
            } else {
                text = this.getBuild().getConfiguration().getName() + ":" + text;
            }
        }
        return text;
    }

    private String abbreviate(String fullText) {
        if (this.maxWidth != 0) {
            return StringUtils.abbreviate((String)fullText, (int)this.maxWidth);
        }
        return fullText;
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.abbreviate(this.getFullText()));
    }

    protected Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }
}

