/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.build.BuildDurationPanel;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.build.BuildProgressBar;
import com.pmease.quickbuild.web.component.build.BuildStatusPanel;
import com.pmease.quickbuild.web.component.build.MoreBuildInfoPanel;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;

public class BuildInfoPanel
extends Panel {
    private boolean showStatus = true;
    private boolean showMoreInfoDropdown = true;
    private boolean showAge = true;
    private boolean showDuration = true;
    private boolean showConfiguration = false;
    private boolean showProgress = true;
    private boolean showStopButton = true;
    private boolean liteMode = false;

    public BuildInfoPanel(String id, IModel<Build> buildModel) {
        super(id, buildModel);
        WebMarkupContainer notNullContainer = new WebMarkupContainer("notNull"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.getBuild() != null);
            }
        };
        this.add(new Component[]{notNullContainer});
        notNullContainer.add(new Component[]{new BuildStatusPanel("status", (IModel)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return BuildInfoPanel.this.getBuild();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.showStatus);
            }
        }});
        notNullContainer.add(new Component[]{new BuildLink("link", (IModel)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return BuildInfoPanel.this.getBuild();
            }
        }, this.showConfiguration, false){

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (BuildInfoPanel.this.liteMode) {
                    tag.put("target", (CharSequence)"_blank");
                } else {
                    String cssClass = tag.getAttribute("class");
                    if (cssClass == null) {
                        cssClass = "";
                    }
                    tag.put("class", (CharSequence)(cssClass + " maskable"));
                }
            }
        }});
        notNullContainer.add(new Component[]{new WebMarkupContainer("moreInfoTrigger"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.showMoreInfoDropdown && !BuildInfoPanel.this.liteMode);
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new MoreBuildInfoPanel(componentId, (Build)BuildManager.instance.load(BuildInfoPanel.this.getBuild().getId()));
            }
        }.hoverMode(false)})});
        notNullContainer.add(new Component[]{new BuildProgressBar("progress", (IModel)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return BuildInfoPanel.this.getBuild();
            }
        }){

            public boolean isVisible() {
                if (!BuildInfoPanel.this.showProgress) {
                    return false;
                }
                return super.isVisible();
            }
        }});
        notNullContainer.add(new Component[]{new Label("age", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return DateUtils.formatAge(BuildInfoPanel.this.getBuild().getEndDate());
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.showAge && BuildInfoPanel.this.getBuild().isFinished() && BuildInfoPanel.this.getBuild().getEndDate() != null);
            }
        }});
        notNullContainer.add(new Component[]{new BuildDurationPanel("duration", (IModel)new AbstractReadOnlyModel<Build>(){

            public Build getObject() {
                return BuildInfoPanel.this.getBuild();
            }
        }, true){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.showDuration);
            }
        }});
        notNullContainer.add(new Component[]{new Link<Void>("stop"){

            public void onClick() {
                BuildEngine.instance.stopBuild(BuildInfoPanel.this.getBuild().getId());
                AuditManager.instance.audit(BuildInfoPanel.this.getBuild().getConfiguration(), "Build " + BuildInfoPanel.this.getBuild().getVersion() + " (#" + BuildInfoPanel.this.getBuild().getId() + ") was stopped.");
                this.getSession().warn((Serializable)((Object)"Stop command issued. The build may take a while to be stopped."));
            }

            protected void onConfigure() {
                super.onConfigure();
                Build build = BuildInfoPanel.this.getBuild();
                Configuration configuration = build.getConfiguration();
                this.setVisible(BuildInfoPanel.this.showStopButton && build.isRunning() && (SecurityHelper.hasPermission(configuration, ConfigurationPermission.STOP_BUILD.name()) || SecurityHelper.hasPermission(configuration, ConfigurationPermission.DELETE_BUILD.name())));
            }
        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to stop this build?")})});
        this.add(new Component[]{new WebMarkupContainer("null"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BuildInfoPanel.this.getBuild() == null);
            }
        }});
        this.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                if (BuildInfoPanel.this.getBuild() != null) {
                    Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(HibernateUtils.getId(BuildInfoPanel.this.getBuild()));
                    return pair != null && pair.getSecond().after(lastRefreshDate);
                }
                visit.dontGoDeeper();
                return false;
            }
        }});
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }

    public BuildInfoPanel showStatus(boolean showStatus) {
        this.showStatus = showStatus;
        return this;
    }

    public BuildInfoPanel showMoreInfoDropdown(boolean showMoreInfoDropdown) {
        this.showMoreInfoDropdown = showMoreInfoDropdown;
        return this;
    }

    public BuildInfoPanel showAge(boolean showAge) {
        this.showAge = showAge;
        return this;
    }

    public BuildInfoPanel showDuration(boolean showDuration) {
        this.showDuration = showDuration;
        return this;
    }

    public BuildInfoPanel showProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public BuildInfoPanel showStopButton(boolean showStopButton) {
        this.showStopButton = showStopButton;
        return this;
    }

    public BuildInfoPanel showConfiguration(boolean showConfiguration) {
        this.showConfiguration = showConfiguration;
        return this;
    }

    public BuildInfoPanel liteMode(boolean liteMode) {
        this.liteMode = liteMode;
        return this;
    }
}

