/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.StringUtils;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class BuildErrorMessage
extends Label {
    public BuildErrorMessage(String id, final IModel<String> errorMessageModel) {
        super(id, (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                String errorMessage = (String)errorMessageModel.getObject();
                if (errorMessage.startsWith("Can not resolve requested build for configuration")) {
                    String configurationPath = StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)errorMessage, (String)"'"), (String)"'");
                    Configuration configuration = ConfigurationManager.instance.get(configurationPath);
                    if (configuration != null) {
                        errorMessage = StringUtils.replace((String)errorMessage, (String)("'" + configurationPath + "'"), (String)("<a href=\"/overview/" + configuration.getId() + "\">" + StringUtils.formatAsHtml(configurationPath) + "</a>"));
                    }
                } else if (errorMessage.startsWith("Dependency build not successful") && !errorMessage.contains("server:")) {
                    String temp = StringUtils.substringAfter((String)errorMessage, (String)"build id:");
                    String buildId = StringUtils.substringBefore((String)temp, (String)")");
                    Build build = (Build)BuildManager.instance.get(Long.valueOf(buildId));
                    if (build != null) {
                        errorMessage = StringUtils.formatAsHtml(errorMessage);
                        String buildVersion = StringUtils.formatAsHtml(build.getVersion());
                        errorMessage = StringUtils.replace((String)errorMessage, (String)("build id:" + buildId), (String)("build:<a href=\"/build/" + buildId + "\">" + buildVersion + "</a>"));
                    }
                } else {
                    errorMessage = StringUtils.formatAsHtml(errorMessage);
                }
                return errorMessage;
            }
        });
        this.setEscapeModelStrings(false);
    }
}

