/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.build;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.visit.IVisit;

public class BuildDurationPanel
extends Panel {
    public BuildDurationPanel(String id, IModel<Build> buildModel, final boolean shortFormat) {
        super(id, buildModel);
        this.add(new Component[]{new Label("duration", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                long duration = BuildDurationPanel.this.getBuild().getDuration() != null ? BuildDurationPanel.this.getBuild().getDuration() : new Date().getTime() - BuildDurationPanel.this.getBuild().getBeginDate().getTime();
                if (shortFormat) {
                    return DateUtils.formatDurationShortWords(duration);
                }
                return DateUtils.formatDuration(duration);
            }
        }).add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                return BuildEngine.instance.getBuild(HibernateUtils.getId(BuildDurationPanel.this.getBuild())) != null;
            }
        }}).setEscapeModelStrings(false)});
    }

    public BuildDurationPanel(String id, IModel<Build> buildModel) {
        this(id, buildModel, false);
    }

    private Build getBuild() {
        return (Build)this.getDefaultModelObject();
    }
}

