/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component;

import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.util.ServletUtils;
import com.pmease.quickbuild.web.component.JavascriptText;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;

public class LogPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean showStep;

    public LogPanel(String id, IModel<? extends Log> model, boolean showStep) {
        super(id, model);
        this.showStep = showStep;
        this.setOutputMarkupId(true);
        this.add(new Component[]{new Label("title", this.getLog().getName())});
        this.add(new Component[]{new Link<Void>("download"){

            public void onClick() {
                RequestCycle.get().scheduleRequestHandlerAfterCurrent(new IRequestHandler(){

                    public void respond(IRequestCycle requestCycle) {
                        InputStream in = null;
                        HttpServletResponse response = (HttpServletResponse)requestCycle.getResponse().getContainerResponse();
                        response.setHeader("Content-Disposition", "attachment;filename=full-log.txt");
                        HttpServletRequest request = ((ServletWebRequest)this.getRequest()).getContainerRequest();
                        String clientLineSeparator = ServletUtils.getLineSeparator(request);
                        try {
                            int bytesRead;
                            in = LogPanel.this.getLog().getTextInputStream(clientLineSeparator, LogPanel.this.showStep);
                            byte[] data = new byte[65536];
                            while ((bytesRead = in.read(data)) != -1) {
                                response.getOutputStream().write(data, 0, bytesRead);
                            }
                        }
                        catch (IOException e) {
                            try {
                                throw new RuntimeException(e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((InputStream)in);
                    }

                    public void detach(IRequestCycle requestCycle) {
                    }
                });
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("scroll"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("onclick", (CharSequence)("javascript:scrollLogTo(" + LogPanel.this.getLog().getAnchorDate().getTime() + ");"));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(LogPanel.this.getLog().getAnchorDate() != null);
            }
        }});
        this.add(new Component[]{new CheckBox("showStep", (IModel)new IModel<Boolean>(){

            public void detach() {
            }

            public Boolean getObject() {
                return LogPanel.this.showStep;
            }

            public void setObject(Boolean object) {
                LogPanel.this.showStep = object;
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(LogPanel.this.getLog() instanceof BuildLog);
            }

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }
        }});
        this.add(new Component[]{new JavascriptText("script", (IModel<String>)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return "retrieveLog('" + LogPanel.this.getLog() + "', " + LogPanel.this.showStep + ")";
            }
        })});
    }

    private Log getLog() {
        return (Log)this.getDefaultModelObject();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.getLog().getAnchorDate() != null) {
            response.renderOnLoadJavaScript("qb.anchorDate=" + this.getLog().getAnchorDate().getTime() + ";");
        }
    }
}

