/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component;

import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.treetable.TreeDataProvider;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTable;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;

public class DirectoryView
extends Panel {
    private Set<String> expandedPaths = new HashSet<String>();
    private TreeTable treeTable;
    private boolean dirDownload;
    private static final int MAX_CHILDREN = 2048;

    public DirectoryView(String id, IModel<File> model) {
        this(id, model, false);
    }

    public DirectoryView(String id, IModel<File> model, boolean dirDownload) {
        super(id, model);
        this.dirDownload = dirDownload;
        Component[] componentArray = new Component[1];
        this.treeTable = new TreeTable("treeTable", new TreeDataProvider(){

            @Override
            public List<Serializable> getChildNodeKeys(Serializable nodeKey) {
                ArrayList<Serializable> childNodeKeys = new ArrayList<Serializable>();
                File file = new File((String)((Object)nodeKey));
                if (file.isDirectory()) {
                    boolean tooManyChildren = false;
                    File[] children = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    if (children != null) {
                        Arrays.sort(children, new Comparator<File>(){

                            @Override
                            public int compare(File file1, File file2) {
                                return file1.getName().compareTo(file2.getName());
                            }
                        });
                        for (File child : children) {
                            if (childNodeKeys.size() >= 2048) {
                                tooManyChildren = true;
                                break;
                            }
                            childNodeKeys.add((Serializable)((Object)child.getAbsolutePath()));
                        }
                    }
                    if (!tooManyChildren && (children = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile();
                        }
                    })) != null) {
                        Arrays.sort(children, new Comparator<File>(){

                            @Override
                            public int compare(File file1, File file2) {
                                return file1.getName().compareTo(file2.getName());
                            }
                        });
                        for (File child : children) {
                            if (childNodeKeys.size() >= 2048) {
                                tooManyChildren = true;
                                break;
                            }
                            childNodeKeys.add((Serializable)((Object)child.getAbsolutePath()));
                        }
                    }
                    if (tooManyChildren) {
                        childNodeKeys.add(new TooManyChildrenMark(file.getAbsolutePath()));
                    }
                }
                return childNodeKeys;
            }

            @Override
            public Serializable getParentNodeKey(Serializable nodeKey) {
                File parent;
                if (nodeKey instanceof TooManyChildrenMark) {
                    TooManyChildrenMark mark = (TooManyChildrenMark)nodeKey;
                    parent = new File(mark.getParentPath());
                } else {
                    parent = new File((String)((Object)nodeKey)).getParentFile();
                }
                return parent.equals(DirectoryView.this.getDirectory()) ? null : parent.getAbsolutePath();
            }

            @Override
            public List<Serializable> getRootNodeKeys() {
                return this.getChildNodeKeys((Serializable)((Object)DirectoryView.this.getDirectory().getAbsolutePath()));
            }

            @Override
            public boolean isExpandable(Serializable nodeKey) {
                if (nodeKey instanceof TooManyChildrenMark) {
                    return false;
                }
                return new File((String)((Object)nodeKey)).isDirectory();
            }
        }, new TreeState(){

            @Override
            public boolean isExpanded(Serializable nodeKey) {
                if (nodeKey instanceof TooManyChildrenMark) {
                    return false;
                }
                return DirectoryView.this.expandedPaths.contains(nodeKey);
            }

            @Override
            public void setExpanded(Serializable nodeKey, boolean expanded) {
                if (!(nodeKey instanceof TooManyChildrenMark)) {
                    if (expanded) {
                        DirectoryView.this.expandedPaths.add((String)((Object)nodeKey));
                    } else {
                        DirectoryView.this.expandedPaths.remove(nodeKey);
                    }
                }
            }
        }, new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                Fragment fragment = new Fragment(id, "nodeFrag", (MarkupContainer)DirectoryView.this);
                if (nodeKey instanceof TooManyChildrenMark) {
                    fragment.add(new Component[]{new InternalImage("icon", "/images/omit.png")});
                    Label label = new Label("link", "<i>Omitted as there are too many</i>");
                    label.setEscapeModelStrings(false);
                    fragment.add(new Component[]{label});
                } else {
                    File file = new File((String)((Object)nodeKey));
                    if (file.isDirectory()) {
                        if (DirectoryView.this.expandedPaths.contains(file.getAbsolutePath())) {
                            fragment.add(new Component[]{new InternalImage("icon", "/images/folder-open.gif")});
                        } else {
                            fragment.add(new Component[]{new InternalImage("icon", "/images/folder.gif")});
                        }
                    } else {
                        fragment.add(new Component[]{new InternalImage("icon", "/images/file.gif")});
                    }
                    fragment.add(new Component[]{DirectoryView.this.newFileLink("link", file)});
                }
                return fragment;
            }

            @Override
            public Component newHeader(String id) {
                return DirectoryView.this.newTreeHeader(id);
            }
        }, new TreeTableColumn[]{new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                if (nodeKey instanceof TooManyChildrenMark) {
                    return new Label(id, " ");
                }
                File file = new File((String)((Object)nodeKey));
                if (file.isFile()) {
                    return new Label(id, FileUtils.byteCountToDisplaySize(file.length()));
                }
                return new Label(id, " ");
            }

            @Override
            public Component newHeader(String id) {
                Label header = new Label(id, "Size");
                header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"bold"))});
                return header;
            }
        }, new TreeTableColumn(){

            @Override
            public Component newCell(String id, Serializable nodeKey) {
                if (nodeKey instanceof TooManyChildrenMark) {
                    return new Label(id, " ");
                }
                return new Label(id, DateUtils.formatDateTime(new Date(new File((String)((Object)nodeKey)).lastModified())));
            }

            @Override
            public Component newHeader(String id) {
                Label header = new Label(id, "Last Modified");
                header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"bold"))});
                return header;
            }
        }}, false);
        componentArray[0] = this.treeTable;
        this.add(componentArray);
    }

    protected Component newFileLink(String id, final File file) {
        Object link;
        Fragment fragment = new Fragment(id, "linkFrag", (MarkupContainer)this);
        if (file.isDirectory()) {
            link = !this.dirDownload ? new WebMarkupContainer("link"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("class", (CharSequence)"not-link");
                }
            } : new Link<Void>("link"){

                public void onClick() {
                    final File tempFile = FileUtils.createTempFile("dirdownload");
                    try {
                        FileUtils.zip(file, tempFile);
                        FileResourceStream resourceStream = new FileResourceStream(new org.apache.wicket.util.file.File(tempFile));
                        this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)resourceStream, file.getName() + ".zip"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void respond(IRequestCycle requestCycle) {
                                try {
                                    super.respond(requestCycle);
                                }
                                finally {
                                    FileUtils.deleteFile(tempFile);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        FileUtils.deleteFile(tempFile);
                    }
                }
            };
            link.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)"Download directory as a zip file"))});
        } else {
            link = new DownloadLink("link", file);
        }
        link.add(new Component[]{new Label("name", (IModel)new Model((Serializable)((Object)file.getName())))});
        fragment.add(new Component[]{link});
        return fragment;
    }

    public Set<File> getSelectedFiles() {
        HashSet<File> selectedFiles = new HashSet<File>();
        for (Serializable key : this.treeTable.getSelectedNodeKeys()) {
            File file = new File((String)((Object)key));
            if (!file.exists()) continue;
            selectedFiles.add(file);
        }
        return selectedFiles;
    }

    public void clearSelection() {
        this.treeTable.clearSelection();
    }

    private File getDirectory() {
        return (File)this.getDefaultModelObject();
    }

    protected Component newTreeHeader(String id) {
        Label header = new Label(id, "Name");
        header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"bold"))});
        return header;
    }

    public static class TooManyChildrenMark
    implements Serializable {
        private String parentPath;

        public TooManyChildrenMark(String parentPath) {
            this.parentPath = parentPath;
        }

        public String getParentPath() {
            return this.parentPath;
        }
    }
}

