/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import com.pmease.quickbuild.web.chart.LineChartData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class LineChart {
    protected abstract LineChartData[] getDatasets();

    protected abstract int getDomainAxisStep();

    protected abstract String domainValueToString(double var1);

    protected void customizeChart(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)Color.white);
    }

    protected Plot getPlot() {
        XYPlot plot = new XYPlot();
        plot.setBackgroundAlpha(0.5f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setNoDataMessage("No Data Available");
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        LineChartData[] datasets = this.getDatasets();
        if (datasets == null || datasets.length == 0) {
            XYSeriesCollection dataset = new XYSeriesCollection();
            XYSeries series = new XYSeries((Comparable)((Object)""));
            dataset.addSeries(series);
            NumberAxis domainAxis = new NumberAxis("");
            NumberAxis rangeAxis = new NumberAxis("");
            plot.setDomainAxis((ValueAxis)domainAxis);
            plot.setRangeAxis((ValueAxis)rangeAxis);
            plot.setDataset((XYDataset)dataset);
            plot.mapDatasetToDomainAxis(0, 0);
            plot.mapDatasetToRangeAxis(0, 0);
            this.customizeDomainAxis(domainAxis);
            return plot;
        }
        NumberAxis domainAxis = new NumberAxis("");
        plot.setDomainAxis((ValueAxis)domainAxis);
        this.customizeDomainAxis(domainAxis);
        plot.mapDatasetToDomainAxis(0, 0);
        this.createRangeAxis(plot, datasets);
        return plot;
    }

    protected void createRangeAxis(XYPlot plot, LineChartData[] datasets) {
        for (int i = 0; i < datasets.length; ++i) {
            XYDataset dataset = datasets[i].getDataset();
            plot.setDataset(i, dataset);
            NumberAxis rangeAxis = new NumberAxis("");
            plot.setRangeAxis(i, (ValueAxis)rangeAxis);
            plot.mapDatasetToRangeAxis(i, i);
            this.customizeRangeAxis(rangeAxis, datasets[i]);
            if (i == 0) {
                plot.mapDatasetToDomainAxis(0, 0);
            }
            rangeAxis.setVisible(i < 2);
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            plot.setRenderer(i, (XYItemRenderer)renderer);
            this.customizeRenderer(renderer, datasets[i], dataset.getItemCount(0) < 35);
        }
    }

    protected void customizeDomainAxis(NumberAxis domainAxis) {
        domainAxis.setAutoRangeIncludesZero(false);
        int step = this.getDomainAxisStep();
        domainAxis.setTickUnit((NumberTickUnit)new DomainTickUnit(step));
        this.postCustomizeDomainAxis(domainAxis);
    }

    protected void postCustomizeDomainAxis(NumberAxis axis) {
    }

    protected void customizeRenderer(XYLineAndShapeRenderer renderer, LineChartData data, boolean withShape) {
        renderer.setSeriesStroke(0, data.getStroke());
        renderer.setSeriesStroke(1, data.getStroke());
        renderer.setSeriesPaint(0, (Paint)data.getColor());
        renderer.setSeriesPaint(1, (Paint)data.getColor());
        renderer.setSeriesFillPaint(0, (Paint)data.getColor());
        renderer.setSeriesFillPaint(1, (Paint)data.getColor());
        if (withShape) {
            renderer.setUseFillPaint(true);
            renderer.setSeriesShapesVisible(0, true);
            renderer.setSeriesShapesVisible(1, false);
            renderer.setSeriesShape(0, data.getShape());
            renderer.setUseOutlinePaint(true);
            renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.0f));
            renderer.setSeriesOutlinePaint(0, (Paint)Color.white);
            renderer.setSeriesOutlinePaint(1, (Paint)Color.white);
        } else {
            renderer.setBaseShapesVisible(false);
        }
        XYToolTipGenerator tooltipGenerator = data.getTooltipGenerator();
        if (tooltipGenerator == null) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        } else {
            renderer.setBaseToolTipGenerator(tooltipGenerator);
        }
    }

    protected void customizeRangeAxis(NumberAxis rangeAxis, LineChartData data) {
        Range range = rangeAxis.getRange();
        double max = range.getUpperBound();
        rangeAxis.setUpperBound(max * 1.1);
        rangeAxis.setLowerBound(0.0 - max * 0.1);
        rangeAxis.setTickUnit(data.getNumberTickUnit());
        this.postCustomizeRangeAxis(rangeAxis);
    }

    protected void postCustomizeRangeAxis(NumberAxis rangeAxis) {
    }

    public JFreeChart getChart() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        JFreeChart chart = new JFreeChart(null, null, plot, false);
        this.customizeChart(chart);
        return chart;
    }

    private class DomainTickUnit
    extends NumberTickUnit {
        private static final long serialVersionUID = 1L;

        public DomainTickUnit(double size) {
            super(size);
        }

        public String valueToString(double value) {
            return LineChart.this.domainValueToString(value);
        }
    }
}

