/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.chart.ChartManager;
import com.pmease.quickbuild.web.component.InternalImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class JFreeChartPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private int count;

    public JFreeChartPanel(String id, int width, int height, IModel<JFreeChart> chartModel) {
        super(id, chartModel);
        this.setOutputMarkupId(true);
        this.width = width;
        this.height = height;
    }

    public JFreeChartPanel(String id, int width, int height, JFreeChart chart) {
        this(id, width, height, (IModel<JFreeChart>)new Model((Serializable)chart));
    }

    protected void onBeforeRender() {
        JFreeChart chart = this.getChart();
        if (chart != null) {
            final String chartKey = UUID.randomUUID().toString() + ".png";
            final ChartRenderingInfo info = new ChartRenderingInfo();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ChartUtilities.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)this.width, (int)this.height, (ChartRenderingInfo)info);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ChartManager.instance.cacheChartBytes(chartKey, baos.toByteArray());
            ++this.count;
            final Label map = new Label("map", (IModel)new LoadableDetachableModel<String>(){
                private static final long serialVersionUID = 1L;

                protected String load() {
                    String mapValue = ChartUtilities.getImageMap((String)"map", (ChartRenderingInfo)info);
                    return StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)mapValue, (String)">"), (String)"<");
                }
            }){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("name", (CharSequence)(this.getMarkupId() + JFreeChartPanel.this.count));
                }
            };
            map.setEscapeModelStrings(false);
            this.addOrReplace(new Component[]{map});
            WebMarkupContainer image = new WebMarkupContainer("image"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("USEMAP", (CharSequence)("#" + map.getMarkupId() + JFreeChartPanel.this.count));
                    tag.put("width", JFreeChartPanel.this.width);
                    tag.put("height", JFreeChartPanel.this.height);
                    tag.put("src", (CharSequence)("/chart/" + chartKey));
                }
            };
            this.addOrReplace(new Component[]{image});
        } else {
            InternalImage image = new InternalImage("image", "/images/report/empty-chart.png");
            image.add(new Behavior[]{new AttributeModifier("width", (IModel)new Model((Serializable)Integer.valueOf(this.width)))});
            image.add(new Behavior[]{new AttributeModifier("height", (IModel)new Model((Serializable)Integer.valueOf(this.height)))});
            this.addOrReplace(new Component[]{image});
            this.addOrReplace(new Component[]{new Label("map", "").setVisible(false)});
        }
        super.onBeforeRender();
    }

    private JFreeChart getChart() {
        return (JFreeChart)this.getDefaultModelObject();
    }
}

